<?php

if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/** @var Claromentis\Setup\SetupFacade $installer */

DBVar::Delete(LmsEmailReminder::LMS_EMAIL_REMINDER_LBL);

$deltree = function ($dir) use ($installer)
{
	if (empty($dir) || $dir === '/')
		return;

	$files = new RecursiveIteratorIterator(
		new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
		RecursiveIteratorIterator::CHILD_FIRST
	);

	/** @var SplFileInfo $fileinfo */
	foreach ($files as $fileinfo)
	{
		$installer->Log("Deleting {$fileinfo->getPathname()}");
		$todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
		if (file_exists($fileinfo->getPathname()))
			$todo($fileinfo->getPathname());
	}

	if (file_exists($dir))
		rmdir($dir);
};

// Data directory
$lms_data_dir = $installer->GetDataDir().'/lms/';
if (file_exists($lms_data_dir))
{
	$deltree($lms_data_dir);
}

// Appdata directory
$cdn = \Claromentis\Core\Services::I()->GetCDN();
$cdn->DeleteDir('lms');

// Plugin removal
$plugins = $installer->GetPluginsRepository();
$plugins->Remove('lms');
