define([], function () {
	// retrieve api base from window.API
	var data_model = {};
	var base = window.cla_scorm_api;

	// 1.2 error code override
	var error_codes = {
		201: {
			short: 'Invalid argument error', full: 'Indicates that an argument represents an invalid data model ' +
			'element or is otherwise incorrect.'
		},
		202: {
			short: 'Element cannot have children', full: 'LMSGetValue was called with a data model element name ' +
			'that ends in “_children” for a data model element that does not support the “_children” suffix.'
		},
		203: {
			short: 'Element not an array. Cannot have count', full: 'LMSGetValue was called with a data model ' +
			'element name that ends in “_count” for a data model element that does not support the “_count” suffix.'
		},
		301: {
			short: 'Not initialized',
			full: 'Indicates that an API call was made before the call to LMSInitialize.'
		},
		401: {
			short: 'Not implemented error',
			full: 'The data model element indicated in a call to LMSGetValue or LMSSetValue is valid, ' +
			'but was not implemented by this LMS. SCORM 1.2 defines a set of data model elements as being optional for an LMS to implement.'
		},
		402: {
			short: 'Invalid set value, element is a keyword', full: 'Indicates that LMSSetValue was called on a ' +
			'data model element that represents a keyword (elements that end in “_children” and “_count”)'
		},
		403: {
			short: 'Element is read only',
			full: 'LMSSetValue was called with a data model element that can only be read.'
		},
		404: {
			short: 'Element is write only', full: 'LMSGetValue was called on a data model element that can only ' +
			'be written to.'
		},
		405: {
			short: 'Incorrect Data Type', full: 'LMSSetValue was called with a value that is not consistent with' +
			' the data format of the supplied data model element.'
		}
	};

	// scorm 1.2 adapter
	var velocidapter = {
		version: '1.2',

		resetInteractions: function () {
			for (var i in base.storage) {
				if (base.storage.hasOwnProperty(i)) {
					if (i.indexOf("cmi.interactions")) {
						delete base.storage[i];
					}
				}
			}
		},

		LMSInitialize: function () {
			var return_val = base.initialize(LMS.scorm_last_question);

			base.storage['cmi.core.lesson_mode'] = 'normal';
			base.storage['cmi.core.lesson_status'] = 'not attempted';
			base.storage['cmi.core.student_name'] = '';
			base.storage['cmi.core.student_id'] = LMS.user_id;
			base.storage['cmi.suspend_data'] = LMS.scorm_suspend_data;
			return return_val;
		},
		LMSGetValue: function (element) {
			var val = '';

			switch (element) {
				case 'cmi.interactions._count':
					val = ++base.question;
					base.log('get : ' + element + ' : ' + val);
					break;
				default:
					val = base.get(element);
					break;
			}

			return val;
		},
		LMSSetValue: function (element, value) {
			switch (element) {
				case 'cmi.core.score.raw':
					var raw = base.get(element);
					// if we suddenly have a lower score, assume reset.
					// please note: this might cause a few issues if it turns out this is possible without a reset.
					if (parseInt(value) < parseInt(raw)) {
						this.resetInteractions();
						base.question = 0;
						base.set('cmi.interactions._count', 0);
					}
					break;
				case 'cmi.suspend_data':
					if (value === '')
					{
						base.storage['cmi.suspend_data'] = LMS.scorm_suspend_data = "";
						this.LMSInitialize();
					}
					break;
				default:
					break;
			}

			return base.set(element, value);
		},
		LMSCommit: function () {
			return base.commit();
		},
		LMSFinish: function () {
			return base.finish();
		},
		LMSGetLastError: function () {
			return base.errorCode();
		},
		LMSGetErrorString: function (code) {
			return base.errorString(code);
		},
		LMSGetDiagnostic: function (code) {
			return base.diagnose(code);
		},
		getErrorCodes: function () {
			return error_codes;
		},
		getDataModel: function () {
			return data_model;
		}
	};

	window.API = velocidapter; // ...clever girl...
	return velocidapter;
});
