define(['jquery', 'cla_select2'], function ($) {

	LMS.removeCategory = function(catId){
		if(!catId) return false;
		var self = this;
		$.ajax({
			type: "DELETE",
			url: "/intranet/rest/lms/course_category/"+catId,
			data: "{}",
			contentType: "application/json; charset=utf-8",
			dataType: "json",
			success: function(response) {
				cla.showMessage(response, '', false);
				var obj = $('#remove-catgory-id-'+catId);
				if(obj.parent().parent().children().length === 1)
				{
					LMS.resetObject(obj.parent());
					LMS.resetCategoryId(obj);
				}
				else $('#remove-catgory-id-'+catId).parent().remove();
			},
			error: function(error){
				cla.showMessage(error.responseText, '', 'info');
			}
		});
		return self;
	};

	LMS.resetObject = function(obj){
		obj.find("option:selected").removeAttr("selected").parent().find("option:first").attr('selected','selected');
		return true;
	};

	LMS.resetCategoryId = function(obj){obj.attr('id', 'remove-catgory-id-0');return true;};
	LMS.resetDependencyId = function(obj){obj.attr('id', 'remove-dependency-id-0');return true;};

	LMS.checkAggregation = function(){return Boolean(LMS.aggreagtion);};

	LMS.removeIcon = function(id){
		if(!id) return false;
		var self = this;
		$.ajax({
			type: "DELETE",
			url: "/intranet/rest/lms/icon/"+LMS.aggreagtion+"/"+id,
			data: "{}",
			contentType: "application/json; charset=utf-8",
			dataType: "json",
			success: function(response) {
				cla.showMessage(response, '', false);
				$('#object-icon-container').remove();
			},
			error: function(error) {
				cla.showMessage(error.responseText, '', 'info');
			}
		});
		return self;
	};

	LMS.removeDependency = function(dependencyId){
		if(!dependencyId)
			return false;
		var self = this;
		$.ajax({
			type: "DELETE",
			url: "/intranet/rest/lms/dependency/"+LMS.aggreagtion+"/"+dependencyId,
			data: "{}",
			contentType: "application/json; charset=utf-8",
			dataType: "json",
			success: function(response) {
				cla.showMessage(response, '', false);
				var obj = $('#remove-dependency-id-'+dependencyId);
				if(obj.parent().parent().children().length === 1) {
					LMS.resetObject(obj.parent());
					LMS.resetDependencyId(obj);
				} else {
					$('#remove-dependency-id-' + dependencyId).parent().remove();
				}
			},
			error: function(error) {
				cla.showMessage(error.responseText, '', 'info');
			}
		});
		return self;
	};

	LMS.changeTab = function(type, downloadButton)
	{
        downloadButton = !!downloadButton;

		if (downloadButton) {
			$('#module-material-download').show();
		} else {
			$('#module-material-download').hide();
		}

		// TODO: Wildcard selector .hide()?
		$('#module-material-type-file').hide();
		$('#module-material-type-2').hide();
		$('#module-material-type-3').hide();
		$('#module-material-type-4').hide();
		$('#module-material-type-7').hide();
		$('#module-material-type-'+type).show();
		return true;
	};

	LMS.userFormatResult = function(user) {
		var markup = '<table class="module-user-result" ><tr>';
		markup += '<td class="module-user-image"><img width="50px" src="' + user.icon + '"/></td>';
		markup += '<td class="module-user-info"><div class="module-user-title">' + user.name + '</div></td></tr></table>';
		return markup;
	};

	LMS.userFormatSelection = function(user) {
		var markup = '<table class="module-user-result" ><tr>';
		markup += '<td class="module-user-image" rel="tooltip" data-placement="top" data-original-title="' + user.name + '"><a href="/intranet/people/viewprofile.php?id='+user.id+'"><img width="50px" src="' + user.icon + '"/></a></td></tr></table>';
		return markup;
	};

	LMS.InitUserPicker = function() {
		$('#module-mark-completed').click(function(){
			LMS.toggleModuleStatus(!!$(this).prop('checked'));
		});
	};

	LMS.changeStatus = function(status)
	{
		switch(status) {
			case LMS.status_completed:
				$('.module-audit-status-container').removeClass('d-none');
				$('#module-audit-status').removeClass().addClass(LMS.status_completed_class).html(LMS.status_completed_lbl);
				break;

			case LMS.status_enrolled:
				$('.module-audit-status-container').removeClass('d-none');
				$('#module-audit-status').removeClass().addClass(LMS.status_enrolled_class).html(LMS.status_enrolled_lbl);
				break;

			default:
				$('.module-audit-status-container').addClass('d-none');
		}
		return true;
	};

	LMS.toggleModuleStatus = function(selected)
	{
		if(selected)
		{
			$.ajax({
				type: "POST",
				url: "/intranet/rest/lms/module_user/"+LMS.module_id+"/"+LMS.user_id,
				data: "{}",
				contentType: "application/json; charset=utf-8",
				dataType: "json",
				error: function(error){
					cla.showMessage(error.responseText, '', 'info');
				},
				success: function() {
					LMS.changeStatus(LMS.status_completed);
				}
			});
		}
		else
		{
			$.ajax({
				type: "POST",
				url: "/intranet/rest/lms/module_user_unroll/"+LMS.module_id+"/"+LMS.user_id,
				data: "{}",
				contentType: "application/json; charset=utf-8",
				dataType: "json",
				error: function(error){
					cla.showMessage(error.responseText, '', 'info');
				},
				success: function() {
					LMS.changeStatus(LMS.status_enrolled);
				}
			});
		}
	};

	LMS.ScormCompleted = function(log)
	{
		log = JSON.parse(log);
		LMS.changeStatus(log['status']);
		LMS.scorm_status = log['status'];
		$('#module-last-access').html(log['last_access']);
	};

	LMS.InitSearchMultiModule = function(display_results, container) {
		container.select2({
			placeholder: lmsg('lms.module.search_for'),
			minimumInputLength: 3,
			multiple: true,
			allowClear: false,
			closeOnSelect: true,
			ajax: {
				url: "/intranet/rest/lms/module_search",
				delay: 300,
				dataType: 'json',
				data: function (params) {
					return {
						q: params.term,
						page_limit: display_results,
						page: params.page,
						exclude: LMS.module_id
					};
				},
				processResults: function (data, page) {
					var result = {
						results: [],
						pagination: {
							more: data.paging.offset + data.paging.limit < data.paging.total
						}
					};
					for (var i = 0; i < data.data.length; i++)
					{
						var el = data.data[i];
						result.results[i] = {
							id: el.id,
							text: el.name
						};
					}
					return result;
				}
			},
			formatResultCssClass: function(data) {return undefined;},
			formatNoMatches: function () { return lmsg('lms.module.users_not_found'); },
			formatInputTooShort: function (input, min) { return  lmsg('lms.module.please_enter',min - input.length); },
			formatSelectionTooBig: function (limit) { return lmsg('lms.module.can_only_select', limit);},
			formatLoadMore: function (pageNumber) { return lmsg('lms.module.loading_more');},
			formatSearching: function () { return lmsg('lms.module.searching'); }
		}).on('change', function(e) {
            $('#dependencies-edited').val(1);
		});
	};

	// return dom events
	return function () {

		// add course category
		var n = 1;
		$(".js-add-category").click(function(){
			var select = $("#course-categories").children(":first").clone();
			select.children(":first").find("option:selected").removeAttr("selected");
			select.find("a").attr("id", "remove-catgory-id-0");
			select.attr('id','newCategory'+n).appendTo("#course-categories");
			n++;
			return false;
		});

		$("#addDependencyCourse").click(function(){
			var select = $("#object-dependencies").children(":first").clone();
			select.children(":first").find("option:selected").removeAttr("selected");
			select.find("a").attr("id", "remove-dependency-id-0");
			select.appendTo("#object-dependencies");
			return false;
		});

		//add course or module
		$("#addDependencyModule").click(function(){
            var containers = $("#object-dependencies").find(".js-dependency-group")

            if (containers.length === 1) {
                var dependencies_container = $("#object-dependencies").find(".dependency-group-container");
                var delete_dependencies_button = dependencies_container.find("a[name*='object-dependency-delete-btn']");

                // append removed button
                if (delete_dependencies_button.length === 0) {
                    var button_delete = $('<a>', {
                        class: 'btn btn-danger js-delete-dependency-group',
                        rel: 'tooltip',
                        "data-placement": "right",
                        "data-original-title": lmsg('lms.add_edit_course.remove_rule'),
                        innerHtml: '<span class="glyphicons-bin glyphicons"></span>'
                    }).appendTo(dependencies_container);

                    $('<span>', {
                        class: 'glyphicons-bin glyphicons'
                    }).appendTo(button_delete);
                }

                if (delete_dependencies_button.is(':hidden')) {
                    delete_dependencies_button.show();
                }
            }

			var last_container = $("#object-dependencies").find(".js-dependency-group:last");
			var last_container_el = last_container.find('.js-dependency-select-element');

			last_container_el.select2('destroy');
			var new_container = last_container.clone();
			LMS.InitSearchMultiModule(10, last_container_el);

			var new_group_id = parseInt(new_container.data('group-id'),10) + 1;
            new_container.attr('data-group-id', new_group_id);
            var new_container_el = new_container.find('.js-dependency-select-element');
			new_container_el.val(null).attr('name', "object-dependency[" + new_group_id + "][]");

			new_container.insertAfter(last_container);
			LMS.InitSearchMultiModule(10, new_container_el);
			return false;
		});

		//add module
		n = 1;
		$("#addModule").click(function(){
			var select = $("#selectModule").clone();
			select.attr('id','selectModule'+n).appendTo(".module");
			n++;
			return false;
		});

		$(document.body).on('click', '.js-delete-category', function(){
			$('.js-delete-category').tooltip('hide');
			var catId = parseInt($(this).attr("id").replace('remove-catgory-id-',''),10);
			var obj = $(this).parents('.lms-category');
			var count = $(this).parents('.lms-categories').children().length;

			if(catId === 0 && count > 1)
				obj.remove();
			else if(catId === 0 && count === 1)
			{
				if(obj.find("option:selected").val() > 0)
					LMS.resetObject(obj);
				else
					cla.showMessage(lmsg('lms.category.nothing_to_remove'), '', 'info');
			}
			else if(catId && confirm(lmsg('lms.category.confirm_delete')))
				LMS.removeCategory(catId);
			return true;
		});

		$(document.body).on('click', '.delete-icon', function(){
			$('.delete-icon').tooltip('hide');
			if(!LMS.checkAggregation())
			{
				cla.showMessage(lmsg('lms.common.missing_aggregation'), '', 'info');
				return false;
			}
			var id = parseInt($(this).attr("id").replace('remove-icon-id-',''),10);
			if(id && confirm(lmsg('lms.image.confirm_delete_icon'))) LMS.removeIcon(id, LMS.aggreagtion);
			return true;
		});

		$(document.body).on('click', '.js-delete-dependency', function(){
			$('.js-delete-dependency').tooltip('hide');
			var dependencyId = parseInt($(this).attr("id").replace('remove-dependency-id-',''),10);
			var obj = $(this).parent();
			var count = $(this).parent().parent().children().length;
			if (dependencyId === 0 && count > 1)
				obj.remove();
			else if(dependencyId === 0 && count === 1)
			{
				if (obj.find("option:selected").val() > 0)
					LMS.resetObject(obj);
				else
					cla.showMessage(lmsg('lms.dependency.nothing_to_remove'), '', 'info');
			}
			else if(dependencyId && confirm(lmsg('lms.common.confirm_rule_remove')))
				LMS.removeDependency(dependencyId);
			return true;
		});

		$(document.body).on('click', '.js-delete-dependency-group', function(){
			$('.js-delete-dependency-group').tooltip('hide');

			var group_container = $(this).closest('.js-dependency-group'),
			//group_id = group_container.data('group-id'),
				modules_element = group_container.find('.js-dependency-select-element'),
				selected_modules_in_group = modules_element.val(),
				groups_count = group_container.parent().find('.js-dependency-group').length;

			//console.log(selected_modules_in_group);

			if ((selected_modules_in_group === null || !selected_modules_in_group.length) && groups_count === 1)
			{
				cla.showMessage(lmsg('lms.dependency.nothing_to_remove'), '', 'info');

                if ($(document.body).find('.js-delete-dependency-group').length === 1) {
                    $('.js-delete-dependency-group').hide();
                }

				return false;
			}
			else if((selected_modules_in_group === null || !selected_modules_in_group.length) && groups_count > 1)
			{
				if (groups_count > 1)
					group_container.remove();
				$('#dependencies-edited').val(1);

                if ($(document.body).find('.js-delete-dependency-group').length === 1) {
                    $('.js-delete-dependency-group').hide();
                }
			}
			else if(confirm(lmsg('lms.common.confirm_rule_remove')))
			{
				if (groups_count > 1)
					group_container.remove();
				else
					modules_element.select2("val", '');
				$('#dependencies-edited').val(1);

                if ($(document.body).find('.js-delete-dependency-group').length === 1) {
                    $('.js-delete-dependency-group').hide();
                }
			}

			return true;
		});

		// Quiz picker
		$('.js-module-material-quiz').select2({
			ajax: {
				url: '/api/quiz/search',
				dataType: 'json',
				delay: 250,
				data: function (parameters) {
					return {
						query: parameters.term,
						page:  parameters.page
					};
				},
				processResults: function (data, parameters) {
					// Ensure that quizzes have a text property
					var quizzes = $.map(data.quizzes, function (quiz) {
						quiz.text = quiz.title;

						return quiz;
					});

					return {
						results: quizzes,
						pagination: {
							more: parameters.page * 20 < data.total
						}
					};
				}
			},
			width: '20em',
			minimumInputLength: 1,
			placeholder: lmsg('lms.material.quiz_placeholder') || 'Please select a Quiz',
			escapeMarkup: function (markup) { return markup; },
			templateSelection: function (quiz, element) {
				return $('<span>').text(quiz.text);
			},
			templateResult: function (quiz, element) {
				// TODO: Do some nice formatting. Use quiz.image_url to show the Quiz cover.
				//       Make sure the title is still escaped, of course.
				// Basic example: return '<img src="' + quiz.image_url + '" width="32px" height="32px"/>' + quiz.title;

				return $(element).text(quiz.title);
			}
		});

	};
});
