<?php
$_db_migration_to = '01.03';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('05_add_folder_for_certificates.php', <<<'DB_UPDATE_FILE'
<?php

global $DATA_DIR;
if (!file_exists($DATA_DIR.'/lms'))
{
	mkdir($DATA_DIR.'/lms');
}
$certificates = $DATA_DIR.'/lms/certificates/';
if(!file_exists($certificates))
{
	mkdir($certificates);
}
DB_UPDATE_FILE
);


$migrations->Run('06_v1.7_videos_module_length.php', <<<'DB_UPDATE_FILE'
<?php
global $DATA_DIR;
$DROP_TABLES = false;

//
// LMS Videos
//
$db->CreateTable('lms_video', array(
	'id'                  => 'IDENTITY',
	'module_id'	      => 'INT NOT_NULL',
	'material_id'         => 'INT NOT_NULL',
	'filename'	      => 'VARCHAR(255) DEFAULT NULL', // 255 is LmsDbHelper::TITLE_LENGTH
	'status'	      => 'INT NOT_NULL DEFAULT 0',
	'video_id'	      => 'VARCHAR(255) DEFAULT NULL', // 255 is LmsDbHelper::TITLE_LENGTH
	'video_width'	      => 'INT NOT_NULL',
	'video_height'	      => 'INT NOT_NULL',
	'created_date'        => 'INT_DATE',
	'created_by'          => 'INT NOT_NULL',
	'updated_date'	      => 'INT_DATE',
), $DROP_TABLES);
$db->CreateIndex('lms_video', 'idx_video_material_id', 'material_id');
$db->CreateIndex('lms_video', 'idx_video_module_id', 'module_id');

@mkdir($DATA_DIR . '/lms/materials/upload/video_tmp'); // /lms/materials/ is LmsMaterial::LMS_DATA_FOLDER

//
// Module Length
//
$db->AddColumn('lms_module', 'module_length', 'INT NOT_NULL DEFAULT 0');

?>
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.03');
