# oEmbed Module

## Description
The oEmbed Module adds an oEmbed library for Pages Components to use. The library is capable of interacting with APIs based on the oEmbed format, and can collect embedded HTML code for Components to display as provided by the 3rd party's response.

### Components
#### Twitter
Embed Tweets, Profiles, Likes, Moments, Lists and Collections from Twitter

### Services
#### Claromentis\oEmbed\CurlFactory
Returns a new `Curl` object, to be used for external server communications.
#### Claromentis\oEmbed\OEmbed
Facilitates performing oEmbed queries on external servers via an `oEmbedQuery` object, and constructing a returned `oEmbedResponse`.
#### Claromentis\oEmbed\OEmbedQueryFactory
Returns a new `OEmbedQuery` object, which can be used for performing oEmbed Queries.
#### Claromentis\oEmbed\OEmbedQueryValidation
Facilitates validation of `OEmbedQuery` object properties, which can be used for user errors.
#### Claromentis\oEmbed\OEmbedResponseFactory
Returns a new `OEmbedResponse` object.

## Installation
### Composer
1. Add `oembed` to your `modules.json`:
```
{
    "claromentis/oembed": "*"
}
```
2. Run the installer from the application directory:
```
clc resolve
```
### Manual Installation
1. Clone the module source into `application/web/intranet/oembed`.
2. Run `clc app:install oembed` from the application directory
