<?php
// This file contains the database schema version 00.03
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// organizations_component_option
$table_descr = array(
	'id'	=>	"IDENTITY",
	'organization_id'	=>	"INT NOT_NULL DEFAULT 0",
	'code'	=>	"VARCHAR(32) NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'value'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('organizations_component_option', $table_descr, true);



// organizations_component_option_string
$table_descr = array(
	'id'	=>	"IDENTITY",
	'organization_id'	=>	"INT NOT_NULL DEFAULT 0",
	'code'	=>	"VARCHAR(32) NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'value'	=>	"CLOB NULL",
);

$db->CreateTable('organizations_component_option_string', $table_descr, true);
$db->CreateIndex('organizations_component_option_string', 'idx_orgid_code_name', 'organization_id', 'code', 'name');



// organizations_history
$table_descr = array(
	'id'	=>	"IDENTITY",
	'organization_id'	=>	"INT NOT_NULL DEFAULT 0",
	'areas'	=>	"VARCHAR(100) NULL DEFAULT ''",
	'changes'	=>	"CLOB NULL",
	'timestamp'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'modified_by'	=>	"INT NOT_NULL DEFAULT 0",
	'source'	=>	"VARCHAR(32) NULL DEFAULT ''",
);

$db->CreateTable('organizations_history', $table_descr, true);



// organizations_organization
$table_descr = array(
	'id'	=>	"IDENTITY",
	'group_id'	=>	"INT NOT_NULL DEFAULT 0",
	'code'	=>	"VARCHAR(50) NULL DEFAULT ''",
	'name'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'legal_name'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'description'	=>	"CLOB NULL",
	'principal_contact_id'	=>	"INT NULL",
	'website'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'phone'	=>	"VARCHAR(40) NULL DEFAULT ''",
	'email'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'address_line1'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'address_line2'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'city'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'region'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'postcode'	=>	"VARCHAR(50) NULL DEFAULT ''",
	'country_id'	=>	"INT NULL",
	'location'	=>	"VARCHAR(255) NULL DEFAULT ''",
	'map_url'	=>	"VARCHAR(512) NULL DEFAULT ''",
	'date_start'	=>	"INT NULL DEFAULT NULL",
	'date_end'	=>	"INT NULL DEFAULT NULL",
	'operational_details'	=>	"CLOB NULL",
	'currency'	=>	"VARCHAR(50) NULL DEFAULT ''",
	'period_type'	=>	"INT NOT_NULL DEFAULT 0",
	'gross_revenue'	=>	"INT NOT_NULL DEFAULT 0",
	'net_revenue'	=>	"INT NOT_NULL DEFAULT 0",
	'net_profit'	=>	"INT NOT_NULL DEFAULT 0",
	'nps'	=>	"INT NOT_NULL DEFAULT 0",
	'as_of_date'	=>	"INT NULL",
	'performance_details'	=>	"CLOB NULL",
	'created_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'modified_date'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
);

$db->CreateTable('organizations_organization', $table_descr, true);





//===========================================================================================
$migrations->SetVersion('00.03');
