<?php
namespace Claromentis\Organizations\Repository;

$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"] ?: array()) + array("_23d5931807d1bdde4e2c5b" . "3adcc4f09d" => base64_decode("Z3Jvd" . "XBuYW" . "1l"), "_4d707fab93bebb00bbe69e8159697c9" . "0" => base64_decode(""), "_18c93a32ba5faf9" . "509389a94787e679" . "8" => base64_decode("bW9kaWZp" . "ZWQ="), "_8dabb06" . "efc95df4" . "cff7c4af" . "e91857b5" . "3" => base64_decode("bmFtZQ=" . "="), "_af0b72c344934" . "514223a36fedd9" . "e810a" => base64_decode("J" . "Q" . "=" . "="), "_bb152d3d0" . "f3a7af77c0" . "42dab184b9" . "545" => base64_decode("P" . "Q" . "=" . "="), "_ed08d8887622a4071ac79b3c5329" . "659d" => base64_decode("Z3J" . "vdX" . "Bfa" . "WQ="), "_ae1577431c2061eb" . "3e71a2ca5b6d1b6f" => base64_decode("Y2" . "9k" . "ZQ" . "=="), "_54b269a12af880b045f67" . "12e6f865462" => base64_decode("c3R" . "hdH" . "Vz"), "_f73dab606630b388" . "645c4f7d3fbb13bb" => base64_decode("YXJyYXlfbWV" . "yZ2U="), "_aeb918f309c1a" . "c9bf44d7449ee6" . "9a709" => base64_decode("bW9kaWZpZW" . "RfZGF0ZQ=="), "_5e9a99dc0dd49" . "b907abf1b35e96" . "965f8" => base64_decode("dHJpbQ=" . "="), "_28fd57f750dbb5f" . "fb3ffad3a888358a" . "9" => base64_decode("ZGVzY3" . "JpcHRp" . "b24="), "_fd3573b00e549f334" . "fe5f4d7536a53ca" => base64_decode("Z3J" . "vdX" . "BpZ" . "A=="), "_25867e3e3db28969253f3a3" . "70c3166ba" => base64_decode("ZGVzYw" . "=="), "_fa0ea3ff84d62d9e" . "b5c8e215ce912e57" => base64_decode("YW5" . "k"), "_9ecb1a728fdb50fbae4581f82" . "4a09366" => base64_decode("bGlr" . "ZQ=="), "_7af8fa1543a4f2c3d3e6350f" . "7f0c4fcd" => base64_decode("YX" . "Nj"), "_d706c160e45b" . "f7434fff82a59" . "76f0e19" => base64_decode("YXJyYXlf" . "a2V5cw=="), "i" . "d" => base64_decode("aW" . "Q="));
use Analogue\ORM\Repository;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Core\Services;
use Claromentis\Organizations\Entity\Organization;
use Claromentis\Organizations\OrganizationFilter;
use Claromentis\Organizations\OrganizationStatus;
use Claromentis\Organizations\Permissions;
use Claromentis\People\Filter\GroupFilter;
use Claromentis\People\Repository\GroupRepository;
use Claromentis\People\Service\UserGroupService;
use Illuminate\Support\Collection;
class OrganizationRepository extends Repository
{
    const GROUP_VISIBILITY_MINE = 1;
    const GROUP_VISIBILITY_ALL = 2;
    
    
    
    
    
    
    
    public function GetOrganizationList(int $_03e9164d0a343b742df4793268b80767 = OrganizationFilter::ACTIVE, $_206f063cdbd5801a283704ef0c883699 = '', $_f6a16426f3b3f03ad6bacec912eec291 = '')
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $context = Services::I()->security;
        
        
        $permissions = Services::I()->{Permissions::class};
        if (!$permissions->CanViewAllOrganizations($context)) {
            
            
            $groupRepo = Services::I()->{GroupRepository::class};
            $_3076cfb1b03de41ca22393abbf2ef426 = $groupRepo->GetGroupsByUserId(new GroupFilter($context), $context->GetUserId());
            $_14e7d5dee412ccf516939d1e99c87733 = $groupRepo->GetAllSubgroups($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_d706c160e45bf7434fff82a5976f" . "0e19"]($_3076cfb1b03de41ca22393abbf2ef426));
            $_d88b50ddb42db648a9c7ac08065b9409->whereIn($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_ed08d888" . "7622a4071" . "ac79b3c53" . "29659d"], $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_d706c160e45bf7434" . "fff82a5976f0e19"]($_14e7d5dee412ccf516939d1e99c87733));
        }
        switch ($_03e9164d0a343b742df4793268b80767) {
            case OrganizationFilter::ACTIVE:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_54b269a1" . "2af880b04" . "5f6712e6f" . "865462"], $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_bb152d3d0f3a7a" . "f77c042dab184b9" . "545"], OrganizationStatus::LIVE);
                break;
            case OrganizationFilter::DRAFT:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_54b269a12af880b045f6712e6f8" . "65462"], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_bb152d3d0f3a7af77c042dab184b95" . "45"], OrganizationStatus::DRAFT);
                break;
            case OrganizationFilter::SUSPENDED:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_54b269a12af880b045f6" . "712e6f865462"], $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_bb152d3d0f3a7a" . "f77c042dab184b9" . "545"], OrganizationStatus::SUSPENDED);
                break;
            case OrganizationFilter::TERMINATED:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_54b269a12af880b045f6712e6f8" . "65462"], $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_bb152d3d0f3a7af77c0" . "42dab184b9545"], OrganizationStatus::TERMINATED);
                break;
            
            
            default:
                break;
        }
        if ($_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8dabb06efc95df4c" . "ff7c4afe91857b53"]) {
            $_d88b50ddb42db648a9c7ac08065b9409->orderBy($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_8dabb06efc95" . "df4cff7c4afe9" . "1857b53"], $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_7af8fa1543a4f2c3d3e6350f" . "7f0c4fcd"]);
        } elseif ($_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_18c93a32ba5faf95" . "09389a94787e6798"]) {
            $_d88b50ddb42db648a9c7ac08065b9409->orderBy($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_aeb918f309c1ac9bf44d7449ee6" . "9a709"], $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_25867e3e3db28969253f3a37" . "0c3166ba"]);
        }
        if ($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_5e9a99dc0dd49b907abf1b35" . "e96965f8"]($_206f063cdbd5801a283704ef0c883699) !== $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_4d707fab93bebb00bbe6" . "9e8159697c90"]) {
            $_85bb20f5360a9a5d29f250748db53ac0 = $this->mapper->newQueryBuilder();
            $_85bb20f5360a9a5d29f250748db53ac0->where($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_8dabb06efc95df4" . "cff7c4afe91857b5" . "3"], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_9ecb1a728fdb50fbae4581f824a093" . "66"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_af0b72c344934514223a36fe" . "dd9e810a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_af0b72c344934514223a36fedd" . "9e810a"]);
            $_85bb20f5360a9a5d29f250748db53ac0->whereOr($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_ae1577431c2061eb" . "3e71a2ca5b6d1b6f"], $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_9ecb1a728fdb" . "50fbae4581f82" . "4a09366"], $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_af0b72c34493451422" . "3a36fedd9e810a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_af0b72c3" . "449345142" . "23a36fedd" . "9e810a"]);
            $_85bb20f5360a9a5d29f250748db53ac0->whereOr($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_28fd57f750dbb5ffb3ffad3a888358a" . "9"], $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_9ecb1a728fdb50fbae4581f824" . "a09366"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_af0b72c344934514223a36fe" . "dd9e810a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_af0b72c34" . "4934514223" . "a36fedd9e8" . "10a"]);
            $_d88b50ddb42db648a9c7ac08065b9409->addNestedWhereQuery($_85bb20f5360a9a5d29f250748db53ac0, $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_fa0ea3ff84d62d9" . "eb5c8e215ce912e5" . "7"]);
        }
        return $_d88b50ddb42db648a9c7ac08065b9409->get();
    }
    public function FindOrganization(int $organizationId) : ?Organization
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["i" . "d"], $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_bb152d3d0f3a7af77c042dab184b9" . "545"], $organizationId);
        $_3fd75875d0e1e227000060b324e3b7ef = $_d88b50ddb42db648a9c7ac08065b9409->get();
        if ($_3fd75875d0e1e227000060b324e3b7ef->count() === 0) {
            return null;
        }
        
        
        return $_3fd75875d0e1e227000060b324e3b7ef->first();
    }
    public function FindOrganizationIdByGroupId(int $groupId) : int
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_ed08d8887622a4071ac79b3c53296" . "59d"], $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_bb152d3d0f3a7af77c042da" . "b184b9545"], $groupId);
        $_3fd75875d0e1e227000060b324e3b7ef = $_d88b50ddb42db648a9c7ac08065b9409->get();
        if ($_3fd75875d0e1e227000060b324e3b7ef->count() === 0) {
            return 0;
        }
        
        
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $_3fd75875d0e1e227000060b324e3b7ef->first();
        return $_abefe39a00d9d468aa7aa7ee9ca696e0->id;
    }
    public function DeleteOrganization(Organization $_abefe39a00d9d468aa7aa7ee9ca696e0)
    {
        $this->mapper->delete($_abefe39a00d9d468aa7aa7ee9ca696e0);
    }
    
    
    
    
    
    
    public function GetAvailableGroups(SecurityContext $context, int $_4334e3c9df4ec41b45044fed86657252 = self::GROUP_VISIBILITY_MINE) : array
    {
        
        
        $_4a59b205eee4ba785cff6fa015a000f4 = Services::I()->{UserGroupService::class};
        
        
        $groupRepo = Services::I()->{GroupRepository::class};
        $_696eb5a0ef41a928671b399093f8e3d7 = $this->all();
        $_8972050331ba380fdf80d3afd7cea936 = [];
        foreach ($_696eb5a0ef41a928671b399093f8e3d7 as $_c44da449b8b4828cbe269cac8a34341f) {
            $_ccffadd43bc75166d819c9bd2a0f053a = $_4a59b205eee4ba785cff6fa015a000f4->GetAllSubgroups([$_c44da449b8b4828cbe269cac8a34341f->group_id]);
            $_8972050331ba380fdf80d3afd7cea936 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_f73dab606630b388645c4f7d3fbb13" . "bb"]($_8972050331ba380fdf80d3afd7cea936, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_d706c160e45bf7" . "434fff82a5976f0" . "e19"]($_ccffadd43bc75166d819c9bd2a0f053a));
        }
        $_d88b50ddb42db648a9c7ac08065b9409 = $groupRepo->query()->whereNotIn($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_fd3573b00e549f334fe5f4d7536a" . "53ca"], $_8972050331ba380fdf80d3afd7cea936);
        if ($_4334e3c9df4ec41b45044fed86657252 === self::GROUP_VISIBILITY_MINE) {
            $_03e9164d0a343b742df4793268b80767 = new GroupFilter($context);
            $_03e9164d0a343b742df4793268b80767->SetFilterByExtranet(true);
            $_3076cfb1b03de41ca22393abbf2ef426 = $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_d706c160e45bf7434fff82a5976f" . "0e19"]($groupRepo->GetGroupsByUserId($_03e9164d0a343b742df4793268b80767, $context->GetUserId()));
            $_14e7d5dee412ccf516939d1e99c87733 = $groupRepo->GetAllSubgroups($_3076cfb1b03de41ca22393abbf2ef426);
            $_d88b50ddb42db648a9c7ac08065b9409->whereIn($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_fd3573b00e549f334fe5" . "f4d7536a53ca"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_d706c160e45bf743" . "4fff82a5976f0e19"]($_14e7d5dee412ccf516939d1e99c87733));
        }
        $_14e7d5dee412ccf516939d1e99c87733 = $_d88b50ddb42db648a9c7ac08065b9409->get([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_fd3573b00e54" . "9f334fe5f4d75" . "36a53ca"], $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_23d5931807d1bdde4e2c5b3ad" . "cc4f09d"]]);
        $_be18d044f62ce168d3312b5e79678a18 = [];
        foreach ($_14e7d5dee412ccf516939d1e99c87733 as $group) {
            $_be18d044f62ce168d3312b5e79678a18[$group[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_fd3573b00e549f334fe5f" . "4d7536a53ca"]]] = $group[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_23d5931807d1bdde4e2c5b3adcc4f09" . "d"]];
        }
        return $_be18d044f62ce168d3312b5e79678a18;
    }
    public function CanUserViewOrganization(SecurityContext $context, int $organizationId) : bool
    {
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $this->FindOrganization($organizationId);
        if ($_abefe39a00d9d468aa7aa7ee9ca696e0 === null) {
            return false;
        }
        
        
        $permissions = Services::I()->{Permissions::class};
        return $permissions->CanViewThisOrganization($context, $_abefe39a00d9d468aa7aa7ee9ca696e0->group_id);
    }
    public function CanUserManageOrganization(SecurityContext $context, int $organizationId) : bool
    {
        
        
        $permissions = Services::I()->{Permissions::class};
        if ($organizationId === 0) {
            
            
            return $permissions->CanManageOrganizations($context);
        }
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $this->FindOrganization($organizationId);
        if ($_abefe39a00d9d468aa7aa7ee9ca696e0 === null) {
            return false;
        }
        return $permissions->CanManageThisOrganization($context, $_abefe39a00d9d468aa7aa7ee9ca696e0->group_id);
    }
}