<?php
$_db_migration_to = '00.02'; // 0.1.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('20250617_initial_schema.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$columns = array
(
	'id'                   => 'IDENTITY',
	'group_id'             => 'INT NOT_NULL DEFAULT 0',
	'code'                 => "VARCHAR(50) DEFAULT ''",
	'name'                 => "VARCHAR(255) DEFAULT ''",
	'legal_name'           => "VARCHAR(255) DEFAULT ''",
	'status'               => 'INT NOT_NULL DEFAULT 0',
	'description'          => 'CLOB NULL',
	'principal_contact_id' => 'INT',
	'website'              => "VARCHAR(255) DEFAULT ''",
	'phone'                => "VARCHAR(40) DEFAULT ''",
	'email'                => "VARCHAR(255) DEFAULT ''",
	'address_line1'        => "VARCHAR(255) DEFAULT ''",
	'address_line2'        => "VARCHAR(255) DEFAULT ''",
	'city'                 => "VARCHAR(255) DEFAULT ''",
	'region'               => "VARCHAR(255) DEFAULT ''",
	'postcode'             => "VARCHAR(50) DEFAULT ''",
	'country_id'           => 'INT',
	'location'             => "VARCHAR(255) DEFAULT ''",
	'map_url'              => "VARCHAR(512) DEFAULT ''",
	'date_start'           => 'INT NULL DEFAULT NULL',
	'date_end'             => 'INT NULL DEFAULT NULL',
	'operational_details'  => 'CLOB NULL',
	'currency'             => "VARCHAR(50) DEFAULT ''",
	'period_type'          => 'INT NOT_NULL DEFAULT 0',
	'gross_revenue'        => 'INT NOT_NULL DEFAULT 0',
	'net_revenue'          => 'INT NOT_NULL DEFAULT 0',
	'net_profit'           => 'INT NOT_NULL DEFAULT 0',
	'nps'                  => 'INT NOT_NULL DEFAULT 0',
	'as_of_date'           => 'INT NULL',
	'performance_details'  => 'CLOB NULL'
);
$db->CreateTable('organizations_organization', $columns, false);

DB_UPDATE_FILE
);


$migrations->Run('20250624_added_dates_and_folders.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('organizations_organization', 'created_date', 'INT_DATE NOT_NULL DEFAULT 0');
$db->AddColumn('organizations_organization', 'created_by', 'INT NOT_NULL DEFAULT 0');
$db->AddColumn('organizations_organization', 'modified_date', 'INT_DATE');
$db->AddColumn('organizations_organization', 'modified_by', 'INT');

$date = new \Date();
$db->query('UPDATE organizations_organization SET created_date = int:date', $date->getDate(DATE_FORMAT_TIMESTAMP));
$db->query('UPDATE organizations_organization SET created_by = int:user_id', 1);

// Add file storage for anything uploaded to the organization description
$cdn = Claromentis\Core\Services::I()->GetCDN();
if (!$cdn->IsDir('organizations'))
	$cdn->CreateDir('organizations');
if (!$cdn->IsDir('organizations/thumbnails'))
	$cdn->CreateDir('organizations/thumbnails');

DB_UPDATE_FILE
);


$migrations->Run('20250716_history_table.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$columns = array
(
	'id'              => 'IDENTITY',
	'organization_id' => 'INT NOT_NULL DEFAULT 0',
	'areas'           => "VARCHAR(100) DEFAULT ''",
	'changes'         => "CLOB NULL",
	'timestamp'       => "INT_DATE NOT_NULL DEFAULT 0",
	'modified_by'     => 'INT NOT_NULL DEFAULT 0',
	'source'          => "VARCHAR(32) DEFAULT ''"
);
$db->CreateTable('organizations_history', $columns, false);

DB_UPDATE_FILE
);


$migrations->Run('20250827_component_options.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$options_desc = [
	'id' => 'IDENTITY',
	'organization_id' => 'INT NOT_NULL DEFAULT 0',
	'code' => 'VARCHAR(32)',
	'name' => 'VARCHAR(255)',
	'value' => 'VARCHAR(255)'
];
$db->CreateTable('organizations_component_option', $options_desc, true);

DB_UPDATE_FILE
);


$migrations->Run('20250924_component_option_strings.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$options_desc = [
	'id' => 'identity',
	'organization_id' => 'INT NOT_NULL DEFAULT 0',
	'code' => 'VARCHAR(32)',
	'name' => 'VARCHAR(255)',
	'value' => 'CLOB'
];
$db->CreateTable('organizations_component_option_string', $options_desc, true);

$db->CreateIndex('organizations_component_option_string', 'idx_orgid_code_name', 'organization_id', 'code', 'name');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('00.02');
