google.maps.importLibrary("maps");
 google.maps.importLibrary("marker");

define(['jquery'], function($){
	return function() {
		this.options = {
			zoom: 16,
            addresses: []
		};
		this.set = function(options) {
			$.extend(this.options, options);

            (g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})({
                key: this.options.apiKey,
                v: "weekly",
                // Use the 'v' parameter to indicate the version to use (weekly, beta, alpha, etc.).
                // Add other bootstrap parameters as needed, using camel case.
            });

			return this;
		};

        this.loadMap = function() {
            var $this = this;
            var addresses = [];

            if (this.options.addresses && this.options.addresses.length > 0) {
                if (typeof this.options.addresses === "string") {
                    try {
                        this.options.addresses = JSON.parse(this.options.addresses);
                    } catch (e) {
                        this.options.addresses = [this.options.addresses];
                    }
                }
                if (Object.prototype.toString.call(this.options.addresses) === "[object Array]") {
                    addresses = this.options.addresses;
                }
            } else {
                $(this.options.addressPlace).each(function() {
                    var txt = $(this).val() ? $(this).val() : $(this).text();
                    if (txt) addresses.push($.trim(txt));
                });
            }

            if (addresses.length === 0) {
                if (this.options.mapPlace) $(this.options.mapPlace).hide();
                return this;
            }

            var requests = addresses.map(function(addr) {
                var url = "https://maps.googleapis.com/maps/api/geocode/json?address="
                    + encodeURIComponent(addr)
                    + "&key=" + google_maps_api_server_key;

                return fetch(url)
                    .then(function(r) { return r.json(); })
                    .then(function(data) {
                        return { addr: addr, data: data };
                    });
            });

            Promise.all(requests)
                .then(function(responses) {
                    if (!Array.isArray(responses)) {
                        responses = [responses];
                    }

                    $this._showMap(responses);

                })
                .catch(function(err) {
                    console.error("Geocode error:", err);
                    if ($this.options.mapPlace) $($this.options.mapPlace).hide();
                });

            return this;
        };


        this._showMap = function(results) {
            var validResults = [];
            for (var i = 0; i < results.length; i++) {
                var r = results[i];
                if (r && r.data && r.data.results && r.data.results[0] && r.data.results[0].geometry) {
                    validResults.push(r.data.results[0]);
                }
            }

            if (validResults.length === 0) {
                console.warn("No valid geocode results found.");
                if (this.options.mapPlace) $(this.options.mapPlace).show();
                return;
            }

            var firstLoc = validResults[0].geometry.location;
            var mapOptions = {
                center: new google.maps.LatLng(firstLoc.lat, firstLoc.lng),
                zoom: this.options.zoom
            };
            var map = new google.maps.Map(document.getElementById(this.options.mapID), mapOptions);

            var bounds = new google.maps.LatLngBounds();

            for (var j = 0; j < validResults.length; j++) {
                var result = validResults[j];
                var loc = result.geometry.location;
                new google.maps.Marker({
                    position: new google.maps.LatLng(loc.lat, loc.lng),
                    map: map,
                    title: result.formatted_address
                });
                bounds.extend(new google.maps.LatLng(loc.lat, loc.lng));
            }

            // If only one location, use configured zoom
            if (validResults.length === 1) {
                map.setZoom(this.options.zoom);
                map.setCenter(bounds.getCenter());
            } else {
                map.fitBounds(bounds);
            }

            if (this.options.mapPlace) $(this.options.mapPlace).show();
        };

        this.autocomplete = function() {
			var $this = this;
            autocomplete = new google.maps.places.Autocomplete(
				(document.getElementById($this.options.addressPlace2))
			);

			google.maps.event.addListener(autocomplete, 'place_changed', function() {
				$this.loadMap();
			});

            // Prevent submitting the form if enter is pressed while choosing a location
            $($this.options.addressPlace).on('keydown', function(evt) {
                if (evt.key === 'Enter')
                    evt.preventDefault();
            });

			return this;
		}
	};
});
