// Element selectors
var iconBtn       = document.querySelector('.js-btn-icon-view');
var listBtn       = document.querySelector('.js-btn-list-view');
var cardContainer = document.querySelector('.js-card-container');
var cards         = document.querySelectorAll('.js-organization-card');

function toggleClassList(el, removeClasses, addClasses) {
    for (var i = 0; i < removeClasses.length; i++) {
        el.classList.remove(removeClasses[i]);
    }
    for (var j = 0; j < addClasses.length; j++) {
        el.classList.add(addClasses[j]);
    }
}

function updateCardLayout(view){
    var isListView = view === 'list';
    var addCardClasses = isListView ? ['col-12'] : ['col-sm-6', 'col-md-4', 'col-xl-3'];
    var removeCardClasses = isListView ? ['col-sm-6', 'col-md-4', 'col-xl-3'] : ['col-12'];
    var showImages = !isListView;

    cards.forEach(function(card) {
        toggleClassList(card, removeCardClasses, addCardClasses);

        card.querySelectorAll('.js-card-image').forEach(function(img) {
            img.classList.toggle('d-none', !showImages);
        });
    });
}

function setViewMode(mode) {
    var isIcon = mode === 'icon';

    iconBtn.classList.toggle('active', isIcon);
    listBtn.classList.toggle('active', !isIcon);
    cardContainer.classList.toggle('list-view', !isIcon);
    updateCardLayout(mode);
    window.localStorage.setItem("organisationsListView", mode);
}

// Event listeners
iconBtn.addEventListener('click', function (e) {
    e.preventDefault();
    setViewMode('icon');
});

listBtn.addEventListener('click', function (e) {
    e.preventDefault();
    setViewMode('list');
});

// On page load
window.addEventListener("load", function(){
    var savedView = window.localStorage.getItem("organisationsListView");

    if (savedView === 'icon' || savedView === 'list') {
        setViewMode(savedView);
    }
});
