<?php
namespace Claromentis\Organizations\Repository;

$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"] ?: array()) + array("_4d707fab93bebb00" . "bbe69e8159697c90" => base64_decode(""), "_9ecb1a728fdb50fb" . "ae4581f824a09366" => base64_decode("bGlrZQ=" . "="), "_fd3573b00e549f334" . "fe5f4d7536a53ca" => base64_decode("Z3JvdXBp" . "ZA=="), "i" . "d" => base64_decode("aW" . "Q="), "_fa0ea3ff84d62d" . "9eb5c8e215ce912" . "e57" => base64_decode("YW" . "5k"), "_28fd57f750" . "dbb5ffb3ffa" . "d3a888358a9" => base64_decode("ZGVzY3" . "JpcHRp" . "b24="), "_8dabb06efc95df4cff7c4afe91" . "857b53" => base64_decode("bmFtZ" . "Q=="), "_bb152d3d0f3a" . "7af77c042dab1" . "84b9545" => base64_decode("PQ" . "=="), "_f73dab606630b388645c4f7d3fb" . "b13bb" => base64_decode("YXJyYXlf" . "bWVyZ2U="), "_ed08d8887622a4071ac79b3c532965" . "9d" => base64_decode("Z3JvdXB" . "faWQ="), "_25867e3e3db2896" . "9253f3a370c3166b" . "a" => base64_decode("ZGV" . "zYw" . "=="), "_d706c160e45bf74" . "34fff82a5976f0e1" . "9" => base64_decode("YXJyYXlfa2V5cw=" . "="), "_54b269a12af880b04" . "5f6712e6f865462" => base64_decode("c3RhdHV" . "z"), "_5e9a99dc0" . "dd49b907ab" . "f1b35e9696" . "5f8" => base64_decode("dH" . "Jp" . "bQ" . "=="), "_23d5931807d1bdde4e2c5b3ad" . "cc4f09d" => base64_decode("Z3Jvd" . "XBuYW" . "1l"), "_7af8fa1543a4f2c3d3e6350f7" . "f0c4fcd" => base64_decode("YXN" . "j"), "_aeb918f309c1ac9bf44" . "d7449ee69a709" => base64_decode("bW9kaWZpZW" . "RfZGF0ZQ=="), "_18c93a32b" . "a5faf95093" . "89a94787e6" . "798" => base64_decode("bW9kaWZp" . "ZWQ="), "_af0b72c34493451422" . "3a36fedd9e810a" => base64_decode("J" . "Q" . "=" . "="), "_ae1577431c2061" . "eb3e71a2ca5b6d1" . "b6f" => base64_decode("Y29k" . "ZQ=="));
use Analogue\ORM\Repository;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Core\Services;
use Claromentis\Organizations\Entity\Organization;
use Claromentis\Organizations\OrganizationFilter;
use Claromentis\Organizations\OrganizationStatus;
use Claromentis\Organizations\Permissions;
use Claromentis\People\Filter\GroupFilter;
use Claromentis\People\Repository\GroupRepository;
use Claromentis\People\Service\UserGroupService;
use Illuminate\Support\Collection;
class OrganizationRepository extends Repository
{
    const GROUP_VISIBILITY_MINE = 1;
    const GROUP_VISIBILITY_ALL = 2;
    
    
    
    
    
    
    
    public function GetOrganizationList(int $_03e9164d0a343b742df4793268b80767 = OrganizationFilter::ACTIVE, $_206f063cdbd5801a283704ef0c883699 = '', $_f6a16426f3b3f03ad6bacec912eec291 = '')
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $context = Services::I()->security;
        
        
        $permissions = Services::I()->{Permissions::class};
        if (!$permissions->CanViewAllOrganizations($context)) {
            
            
            $groupRepo = Services::I()->{GroupRepository::class};
            $_3076cfb1b03de41ca22393abbf2ef426 = $groupRepo->GetGroupsByUserId(new GroupFilter($context), $context->GetUserId());
            $_14e7d5dee412ccf516939d1e99c87733 = $groupRepo->GetAllSubgroups($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_d706c160e45bf7434fff82" . "a5976f0e19"]($_3076cfb1b03de41ca22393abbf2ef426));
            $_d88b50ddb42db648a9c7ac08065b9409->whereIn($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_ed08d888" . "7622a4071" . "ac79b3c53" . "29659d"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_d706c160e" . "45bf7434ff" . "f82a5976f0" . "e19"]($_14e7d5dee412ccf516939d1e99c87733));
        }
        switch ($_03e9164d0a343b742df4793268b80767) {
            case OrganizationFilter::ACTIVE:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_54b269a12af880b0" . "45f6712e6f865462"], $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_bb152d3d0f3a7af" . "77c042dab184b954" . "5"], OrganizationStatus::LIVE);
                break;
            case OrganizationFilter::DRAFT:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_54b269a12af880b045" . "f6712e6f865462"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_bb152d3d0f" . "3a7af77c042" . "dab184b9545"], OrganizationStatus::DRAFT);
                break;
            case OrganizationFilter::SUSPENDED:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_54b269a12af88" . "0b045f6712e6f8" . "65462"], $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_bb152d3d0f3a7af77c042dab184b95" . "45"], OrganizationStatus::SUSPENDED);
                break;
            case OrganizationFilter::TERMINATED:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_54b269a12af880b045f6712e6f86546" . "2"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_bb152d3d0f3a7af77c042dab184b" . "9545"], OrganizationStatus::TERMINATED);
                break;
            
            
            default:
                break;
        }
        if ($_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_8dabb06efc9" . "5df4cff7c4af" . "e91857b53"]) {
            $_d88b50ddb42db648a9c7ac08065b9409->orderBy($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_8dabb06ef" . "c95df4cff7" . "c4afe91857" . "b53"], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_7af8fa154" . "3a4f2c3d3e" . "6350f7f0c4" . "fcd"]);
        } elseif ($_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_18c93a32ba5faf9509389a94" . "787e6798"]) {
            $_d88b50ddb42db648a9c7ac08065b9409->orderBy($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_aeb918f309c1ac9b" . "f44d7449ee69a709"], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_25867e3e3db28969253f3a370c31" . "66ba"]);
        }
        if ($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_5e9a99dc0dd49b907ab" . "f1b35e96965f8"]($_206f063cdbd5801a283704ef0c883699) !== $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_4d707fab93beb" . "b00bbe69e81596" . "97c90"]) {
            $_85bb20f5360a9a5d29f250748db53ac0 = $this->mapper->newQueryBuilder();
            $_85bb20f5360a9a5d29f250748db53ac0->where($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8dabb06efc" . "95df4cff7c4" . "afe91857b53"], $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_9ecb1a728fdb50fbae4581f824" . "a09366"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_af0b72c344934514223a36fe" . "dd9e810a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_af0b72c34493451422" . "3a36fedd9e810a"]);
            $_85bb20f5360a9a5d29f250748db53ac0->whereOr($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_ae1577431c2061eb3e71a2ca5b6d1b6" . "f"], $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_9ecb1a728fdb50fbae45" . "81f824a09366"], $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_af0b72c34493" . "4514223a36fed" . "d9e810a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_af0b72c344934514223a36fedd9e81" . "0a"]);
            $_85bb20f5360a9a5d29f250748db53ac0->whereOr($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_28fd57f750dbb5ffb3f" . "fad3a888358a9"], $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_9ecb1a728fdb5" . "0fbae4581f824a" . "09366"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_af0b72c344934514223a36fedd9" . "e810a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_af0b72c344934514223a36fedd9e810" . "a"]);
            $_d88b50ddb42db648a9c7ac08065b9409->addNestedWhereQuery($_85bb20f5360a9a5d29f250748db53ac0, $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_fa0ea3ff" . "84d62d9eb" . "5c8e215ce" . "912e57"]);
        }
        return $_d88b50ddb42db648a9c7ac08065b9409->get();
    }
    public function FindOrganization(int $organizationId) : ?Organization
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["i" . "d"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_bb152d3d0f3a7af77c0" . "42dab184b9545"], $organizationId);
        $_3fd75875d0e1e227000060b324e3b7ef = $_d88b50ddb42db648a9c7ac08065b9409->get();
        if ($_3fd75875d0e1e227000060b324e3b7ef->count() === 0) {
            return null;
        }
        
        
        return $_3fd75875d0e1e227000060b324e3b7ef->first();
    }
    public function FindOrganizationIdByGroupId(int $groupId) : int
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_ed08d8887622a4071ac79b" . "3c5329659d"], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_bb152d3d0f3a7af77c042dab184" . "b9545"], $groupId);
        $_3fd75875d0e1e227000060b324e3b7ef = $_d88b50ddb42db648a9c7ac08065b9409->get();
        if ($_3fd75875d0e1e227000060b324e3b7ef->count() === 0) {
            return 0;
        }
        
        
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $_3fd75875d0e1e227000060b324e3b7ef->first();
        return $_abefe39a00d9d468aa7aa7ee9ca696e0->id;
    }
    public function DeleteOrganization(Organization $_abefe39a00d9d468aa7aa7ee9ca696e0)
    {
        $this->mapper->delete($_abefe39a00d9d468aa7aa7ee9ca696e0);
    }
    
    
    
    
    
    
    public function GetAvailableGroups(SecurityContext $context, int $_4334e3c9df4ec41b45044fed86657252 = self::GROUP_VISIBILITY_MINE) : array
    {
        
        
        $_4a59b205eee4ba785cff6fa015a000f4 = Services::I()->{UserGroupService::class};
        
        
        $groupRepo = Services::I()->{GroupRepository::class};
        $_696eb5a0ef41a928671b399093f8e3d7 = $this->all();
        $_8972050331ba380fdf80d3afd7cea936 = [];
        foreach ($_696eb5a0ef41a928671b399093f8e3d7 as $_c44da449b8b4828cbe269cac8a34341f) {
            $_ccffadd43bc75166d819c9bd2a0f053a = $_4a59b205eee4ba785cff6fa015a000f4->GetAllSubgroups([$_c44da449b8b4828cbe269cac8a34341f->group_id]);
            $_8972050331ba380fdf80d3afd7cea936 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f73dab606630b388645c4f7" . "d3fbb13bb"]($_8972050331ba380fdf80d3afd7cea936, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_d706c160e45bf7434fff82a5976f0e" . "19"]($_ccffadd43bc75166d819c9bd2a0f053a));
        }
        $_d88b50ddb42db648a9c7ac08065b9409 = $groupRepo->query()->whereNotIn($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_fd3573b00e549f" . "334fe5f4d7536a5" . "3ca"], $_8972050331ba380fdf80d3afd7cea936);
        if ($_4334e3c9df4ec41b45044fed86657252 === self::GROUP_VISIBILITY_MINE) {
            $_03e9164d0a343b742df4793268b80767 = new GroupFilter($context);
            $_03e9164d0a343b742df4793268b80767->SetFilterByExtranet(true);
            $_3076cfb1b03de41ca22393abbf2ef426 = $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_d706c160e45bf7434fff82a5976f" . "0e19"]($groupRepo->GetGroupsByUserId($_03e9164d0a343b742df4793268b80767, $context->GetUserId()));
            $_14e7d5dee412ccf516939d1e99c87733 = $groupRepo->GetAllSubgroups($_3076cfb1b03de41ca22393abbf2ef426);
            $_d88b50ddb42db648a9c7ac08065b9409->whereIn($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_fd3573b00e549f334fe5f4d7" . "536a53ca"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_d706c160e45bf7434fff82a5976" . "f0e19"]($_14e7d5dee412ccf516939d1e99c87733));
        }
        $_14e7d5dee412ccf516939d1e99c87733 = $_d88b50ddb42db648a9c7ac08065b9409->get([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_fd3573b00e549" . "f334fe5f4d7536" . "a53ca"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_23d593180" . "7d1bdde4e2" . "c5b3adcc4f" . "09d"]]);
        $_be18d044f62ce168d3312b5e79678a18 = [];
        foreach ($_14e7d5dee412ccf516939d1e99c87733 as $group) {
            $_be18d044f62ce168d3312b5e79678a18[$group[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_fd3573b00e549f3" . "34fe5f4d7536a53c" . "a"]]] = $group[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_23d5931807" . "d1bdde4e2c5" . "b3adcc4f09d"]];
        }
        return $_be18d044f62ce168d3312b5e79678a18;
    }
    public function CanUserViewOrganization(SecurityContext $context, int $organizationId) : bool
    {
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $this->FindOrganization($organizationId);
        if ($_abefe39a00d9d468aa7aa7ee9ca696e0 === null) {
            return false;
        }
        
        
        $permissions = Services::I()->{Permissions::class};
        return $permissions->CanViewThisOrganization($context, $_abefe39a00d9d468aa7aa7ee9ca696e0->group_id);
    }
    public function CanUserManageOrganization(SecurityContext $context, int $organizationId) : bool
    {
        
        
        $permissions = Services::I()->{Permissions::class};
        if ($organizationId === 0) {
            
            
            return $permissions->CanManageOrganizations($context);
        }
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $this->FindOrganization($organizationId);
        if ($_abefe39a00d9d468aa7aa7ee9ca696e0 === null) {
            return false;
        }
        return $permissions->CanManageThisOrganization($context, $_abefe39a00d9d468aa7aa7ee9ca696e0->group_id);
    }
}