<?php
namespace Claromentis\Organizations;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] = (@$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"] ?: array()) + array("_bd71c3b5c201fc" . "11db82ed14ce424" . "de5" => base64_decode("aW5fYX" . "JyYXk="), "_0c5123aa744f69bbc0e" . "8b3ea2f6e847d" => base64_decode("bG1" . "zZw" . "=="), "_d706c160e45bf7434fff82a5976" . "f0e19" => base64_decode("YXJyYXlfa2V" . "5cw=="), "_9c52c9000247c2bef8b4ce20b89b7f7" . "b" => base64_decode("b3JnYW5pemF0aW9ucy5hZG1pbi5wZXJtcy5tYW5" . "hZ2VfYWxs"), "_70d314620dd04f5be30" . "ade43e386eef4" => base64_decode("b3JnYW5pemF0aW9uc" . "y5hZG1pbi5wZXJtcy" . "52aWV3X2FsbA=="), "_f7e22d832ab9652034" . "75de0a07393c5a" => base64_decode("b3JnYW5pemF0aW9ucy5hZG1pbi5wZXJt" . "cy5tYW5hZ2VfbXlfZ3JvdXBz"), "_bf9fa234f3" . "ee83f12f62a" . "c78132259ac" => base64_decode("b3JnYW5pemF0aW9ucy5hZG1pbi" . "5wZXJtcy5kZWxldGVfYW55"));
use Claromentis\Core\Acl\Acl;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People\Filter\GroupFilter;
use Claromentis\People\Repository\GroupRepository;
class Permissions
{
    const CLASS_ORGANIZATIONS = 152;
    const RIGHTS_VIEW_ALL = 0b1;
    const RIGHTS_VIEW_DASHBOARD = 0b10;
    const RIGHTS_MANAGE_MY_GROUPS = 0b100;
    const RIGHTS_MANAGE_ALL = 0b1100;
    
    
    const RIGHTS_DELETE_ANY = 0b10000;
    protected Acl $acl;
    protected GroupRepository $groupRepo;
    public static function GetPerms()
    {
        return [
            self::RIGHTS_VIEW_ALL => [$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_0c5123aa744f6" . "9bbc0e8b3ea2f6" . "e847d"]($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_70d314620dd" . "04f5be30ade4" . "3e386eef4"]), true],
            
            
            
            self::RIGHTS_MANAGE_MY_GROUPS => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_0c5123aa744f69bbc" . "0e8b3ea2f6e847d"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_f7e22d832ab" . "965203475de0" . "a07393c5a"]), true],
            self::RIGHTS_MANAGE_ALL => [$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_0c5123aa744f69bbc0e8" . "b3ea2f6e847d"]($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_9c52c9000247c2bef8b4ce20b89b" . "7f7b"]), true],
            self::RIGHTS_DELETE_ANY => [$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_0c5123aa744f69bbc0e" . "8b3ea2f6e847d"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_bf9fa234f3ee83f12f62ac7" . "8132259ac"]), true],
        ];
    }
    public function __construct(Acl $_02752cdc22229457e909d01fb90d3a62, GroupRepository $groupRepo)
    {
        $this->acl = $_02752cdc22229457e909d01fb90d3a62;
        $this->groupRepo = $groupRepo;
    }
    public function CanViewAllOrganizations(SecurityContext $context) : bool
    {
        return $this->acl->Permits($context, self::RIGHTS_VIEW_ALL);
    }
    public function CanViewThisOrganization(SecurityContext $context, int $groupId) : bool
    {
        if ($this->acl->Permits($context, self::RIGHTS_VIEW_ALL)) {
            return true;
        }
        
        
        $_03e9164d0a343b742df4793268b80767 = new GroupFilter($context);
        $_03e9164d0a343b742df4793268b80767->SetFilterByExtranet(true);
        $_3076cfb1b03de41ca22393abbf2ef426 = $this->groupRepo->GetGroupsByUserId($_03e9164d0a343b742df4793268b80767, $context->GetUserId());
        $_14e7d5dee412ccf516939d1e99c87733 = $this->groupRepo->GetAllSubgroups($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_d706c160e45bf7434fff82" . "a5976f0e19"]($_3076cfb1b03de41ca22393abbf2ef426));
        if ($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_bd71c3b5c201fc11db82ed1" . "4ce424de5"]($groupId, $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_d706c160e45bf7434fff82a5" . "976f0e19"]($_14e7d5dee412ccf516939d1e99c87733))) {
            return true;
        }
        return false;
    }
    public function CanManageOrganizations(SecurityContext $context) : bool
    {
        if ($this->acl->Permits($context, self::RIGHTS_MANAGE_ALL)) {
            return true;
        }
        if ($this->acl->Permits($context, self::RIGHTS_MANAGE_MY_GROUPS)) {
            return true;
        }
        return false;
    }
    public function CanManageAllOrganizations(SecurityContext $context) : bool
    {
        return $this->acl->Permits($context, self::RIGHTS_MANAGE_ALL);
    }
    public function CanManageMyOrganizations(SecurityContext $context) : bool
    {
        return $this->acl->Permits($context, self::RIGHTS_MANAGE_MY_GROUPS);
    }
    public function CanDeleteOrganizations(SecurityContext $context) : bool
    {
        return $this->acl->Permits($context, self::RIGHTS_DELETE_ANY);
    }
    public function CanManageThisOrganization(SecurityContext $context, int $groupId) : bool
    {
        
        
        if (!$this->CanManageOrganizations($context)) {
            return false;
        }
        
        
        if ($groupId === 0) {
            return true;
        }
        
        
        if ($this->CanManageAllOrganizations($context)) {
            return true;
        }
        
        
        $_03e9164d0a343b742df4793268b80767 = new GroupFilter($context);
        $_03e9164d0a343b742df4793268b80767->SetFilterByExtranet(true);
        $_3076cfb1b03de41ca22393abbf2ef426 = $this->groupRepo->GetGroupsByUserId($_03e9164d0a343b742df4793268b80767, $context->GetUserId());
        $_14e7d5dee412ccf516939d1e99c87733 = $this->groupRepo->GetAllSubgroups($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_d706c160e45bf7434fff82a5976f0e1" . "9"]($_3076cfb1b03de41ca22393abbf2ef426));
        if ($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_bd71c3b5c201fc11db82" . "ed14ce424de5"]($groupId, $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_d706c160e45bf7434fff82a5976f0" . "e19"]($_14e7d5dee412ccf516939d1e99c87733))) {
            return true;
        }
        
        
        return false;
    }
}