<?php
if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/**
 * @var $installer \Claromentis\Setup\SetupFacade
 */
$plugins = $installer->GetPluginsRepository();
$plugins->Add('organizations', 'Claromentis\Organizations\OrganizationsApplication', ['dmsv', 'pages', 'peoplecomponent', 'discuss']);

$panels = $installer->GetAdminPanelCreator();
$panels->Enable('organizations');

use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('organizations', 'Organisations', '/organizations/'));

// Add file storage for anything uploaded to the project description
$cdn = Claromentis\Core\Services::I()->GetCDN();
if (!$cdn->IsDir('projects'))
	$cdn->CreateDir('projects');
if (!$cdn->IsDir('projects/thumbnails'))
	$cdn->CreateDir('projects/thumbnails');
