<?php
if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/**
 * @var $installer \Claromentis\Setup\SetupFacade
 */
$plugins = $installer->GetPluginsRepository();
$plugins->Add('organizations', 'Claromentis\Organizations\OrganizationsApplication', ['dmsv', 'pages', 'peoplecomponent', 'discuss']);

$panels = $installer->GetAdminPanelCreator();
$panels->Enable('organizations');

use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('organizations', 'Organisations', '/organizations/'));

// Add file storage for thumbnails and anything uploaded to the organisation descriptions
$cdn = Claromentis\Core\Services::I()->GetCDN();
if (!$cdn->IsDir('organizations'))
	$cdn->CreateDir('organizations');
if (!$cdn->IsDir('organizations/thumbnails'))
	$cdn->CreateDir('organizations/thumbnails');
