define(['jquery', 'cla_highcharts'], function($, Highcharts)
{
    var NpsChart = function(target, data) {
        this.target = target;
        this.data = data;
    }

    NpsChart.prototype.Init = function() {
        var self = this;

        self.Show(this.data);
    }

    NpsChart.prototype.Show = function(rawData) {
        var targetEl = document.querySelector('#' + this.target);
        if (targetEl.length === 0)
            return;

        // sort by nps descending
        rawData.sort(function(a, b) {
            return b.nps - a.nps;
        });

        // map into Highcharts-ready format
        var chartData = rawData.map(function(item) {
            return { name: item.id, realName: item.name, y: item.nps, id: item.id };
        });

        var idMap = [];
        chartData.forEach(function(d){
            idMap['org-' + d.id] = d.realName;
        });

        //Calculate the chart's height based upon the number of Organizations
        var categories = rawData.map(function (d) { return d.name; });
        var barHeight = 32;
        var chartHeight = Math.max(categories.length * barHeight, 250);

        var chart = new Highcharts.Chart({
            chart: {
                renderTo: this.target,
                type: 'bar',
                height: chartHeight,
            },
            accessibility: {
                enabled: true,
                keyboardNavigation: { enabled: true }
            },
            tooltip: {
                enabled: false
            },
            title: { text: null },
            xAxis: {
                visible: true,
                type: 'category',
                title: { text: null },
                labels: {
                    style: {
                        fontSize: '.875rem',
                    },
                    useHTML: true,
                    step: 1,
                    formatter: function () {
                        return '<a class="text-dark organization-graph-link text-truncate d-block" href="/organizations/organization/' + this.value + '">' + idMap['org-' + this.value] + '</a>';
                    }
                }
            },
            yAxis: {
                visible: false,
            },
            plotOptions: {
                bar: {
                    dataLabels: {
                        enabled: true,
                        useHTML: true,
                    },
                },
                series: {
                    dataSorting: { enabled: true, sortKey: 'y' }
                }
            },
            credits: { enabled: false },
            series: [{
                name: 'NPS score',
                showInLegend: false,
                pointWidth: 29,
                data: chartData,
                zones: [
                    { value: 0, color: 'var(--nps-red)' },
                    { value: 31, color: 'var(--nps-amber)' },
                    { value: 71, color: 'var(--nps-green)' },
                    { value: 101, color: 'var(--nps-dark-green)' }
                ]
            }]
        })
    }

    return NpsChart;
})
