<?php
namespace Claromentis\Organizations\Repository;

$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] ?: array()) + array("_4d707fab93bebb00bbe69e8159697" . "c90" => base64_decode(""), "_aeb918f309c1ac9" . "bf44d7449ee69a70" . "9" => base64_decode("bW9kaWZpZ" . "WRfZGF0ZQ" . "=="), "_28fd57f750dbb5ffb3ffad3" . "a888358a9" => base64_decode("ZGVzY3JpcHRpb2" . "4="), "_18c93a32ba5fa" . "f9509389a94787" . "e6798" => base64_decode("bW9ka" . "WZpZW" . "Q="), "_7af8fa1543a4f2c3d3e6350" . "f7f0c4fcd" => base64_decode("YX" . "Nj"), "_fa0ea3ff84d62d9eb5c8e215ce912" . "e57" => base64_decode("Y" . "W" . "5" . "k"), "_5e9a99dc0dd49b9" . "07abf1b35e96965f" . "8" => base64_decode("dHJpb" . "Q=="), "_23d5931807d1b" . "dde4e2c5b3adcc" . "4f09d" => base64_decode("Z3JvdXB" . "uYW1l"), "_bb152d3d0f3a7" . "af77c042dab184" . "b9545" => base64_decode("PQ=" . "="), "_ae1577431c2061eb" . "3e71a2ca5b6d1b6f" => base64_decode("Y29" . "kZQ" . "=="), "_fd3573b00e549" . "f334fe5f4d7536" . "a53ca" => base64_decode("Z3Jv" . "dXBp" . "ZA=="), "_af0b72c344934514223a36fedd9e8" . "10a" => base64_decode("J" . "Q" . "=" . "="), "_8dabb06e" . "fc95df4cf" . "f7c4afe91" . "857b53" => base64_decode("bmF" . "tZQ" . "=="), "_d706c160e45bf7434fff82a5" . "976f0e19" => base64_decode("YXJyYXlfa2V5c" . "w=="), "_f73dab606630b388645c4f7d3fb" . "b13bb" => base64_decode("YXJyYXlfbWVyZ2" . "U="), "_ed08d8887622a4071ac79b3c53" . "29659d" => base64_decode("Z3JvdX" . "BfaWQ="), "_25867e3e3db28969253f3a370c3166b" . "a" => base64_decode("ZGVzYw" . "=="), "_9ecb1a728fdb50fbae4581f82" . "4a09366" => base64_decode("bGlr" . "ZQ=="), "i" . "d" => base64_decode("aWQ" . "="), "_54b269a12af880b045f6712e6f8" . "65462" => base64_decode("c3RhdH" . "Vz"));
use Analogue\ORM\Repository;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Core\Services;
use Claromentis\Organizations\Entity\Organization;
use Claromentis\Organizations\OrganizationFilter;
use Claromentis\Organizations\OrganizationStatus;
use Claromentis\Organizations\Permissions;
use Claromentis\People\Filter\GroupFilter;
use Claromentis\People\Repository\GroupRepository;
use Claromentis\People\Service\UserGroupService;
use Illuminate\Support\Collection;
class OrganizationRepository extends Repository
{
    const GROUP_VISIBILITY_MINE = 1;
    const GROUP_VISIBILITY_ALL = 2;
    
    
    
    
    
    
    
    public function GetOrganizationList(int $_03e9164d0a343b742df4793268b80767 = OrganizationFilter::ACTIVE, $_206f063cdbd5801a283704ef0c883699 = '', $_f6a16426f3b3f03ad6bacec912eec291 = '')
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $context = Services::I()->security;
        
        
        $permissions = Services::I()->{Permissions::class};
        if (!$permissions->CanViewAllOrganizations($context)) {
            
            
            $groupRepo = Services::I()->{GroupRepository::class};
            $_3076cfb1b03de41ca22393abbf2ef426 = $groupRepo->GetGroupsByUserId(new GroupFilter($context), $context->GetUserId());
            $_14e7d5dee412ccf516939d1e99c87733 = $groupRepo->GetAllSubgroups($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_d706c160e45bf7434fff" . "82a5976f0e19"]($_3076cfb1b03de41ca22393abbf2ef426));
            $_d88b50ddb42db648a9c7ac08065b9409->whereIn($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_ed08d8887622a" . "4071ac79b3c532" . "9659d"], $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_d706c160e4" . "5bf7434fff8" . "2a5976f0e19"]($_14e7d5dee412ccf516939d1e99c87733));
        }
        switch ($_03e9164d0a343b742df4793268b80767) {
            case OrganizationFilter::ACTIVE:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_54b269a1" . "2af880b04" . "5f6712e6f" . "865462"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_bb152d3d0" . "f3a7af77c0" . "42dab184b9" . "545"], OrganizationStatus::LIVE);
                break;
            case OrganizationFilter::DRAFT:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_54b269a12af880b045" . "f6712e6f865462"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_bb152d3d0f3a7af77c042dab18" . "4b9545"], OrganizationStatus::DRAFT);
                break;
            case OrganizationFilter::SUSPENDED:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_54b269a12a" . "f880b045f67" . "12e6f865462"], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_bb152d3d0f3a7af77c042dab18" . "4b9545"], OrganizationStatus::SUSPENDED);
                break;
            case OrganizationFilter::TERMINATED:
                $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_54b269a12af880b045f67" . "12e6f865462"], $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_bb152d3d" . "0f3a7af77" . "c042dab18" . "4b9545"], OrganizationStatus::TERMINATED);
                break;
            
            
            default:
                break;
        }
        if ($_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8dabb06efc95df4cff7c4" . "afe91857b53"]) {
            $_d88b50ddb42db648a9c7ac08065b9409->orderBy($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_8dabb06efc95df4cff7c" . "4afe91857b53"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_7af8fa1543a4f2c3d3e6350f7f0" . "c4fcd"]);
        } elseif ($_f6a16426f3b3f03ad6bacec912eec291 === $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_18c93a32ba5faf95093" . "89a94787e6798"]) {
            $_d88b50ddb42db648a9c7ac08065b9409->orderBy($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_aeb918f309c1ac9bf44" . "d7449ee69a709"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_25867e3e3db28969253f3a370c3" . "166ba"]);
        }
        if ($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_5e9a99dc0dd49b907abf1b35e969" . "65f8"]($_206f063cdbd5801a283704ef0c883699) !== $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_4d707fab93bebb00bbe69e8" . "159697c90"]) {
            $_85bb20f5360a9a5d29f250748db53ac0 = $this->mapper->newQueryBuilder();
            $_85bb20f5360a9a5d29f250748db53ac0->where($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_8dabb06efc95df4cff7c4afe9" . "1857b53"], $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_9ecb1a728fdb5" . "0fbae4581f824a" . "09366"], $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_af0b72c344934514223a36fedd9e8" . "10a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_af0b72c344934514223a3" . "6fedd9e810a"]);
            $_85bb20f5360a9a5d29f250748db53ac0->whereOr($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_ae1577431c2061eb3e71" . "a2ca5b6d1b6f"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_9ecb1a728fdb50fbae4581f824a0936" . "6"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_af0b72c344934514223a36fedd9e810" . "a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_af0b72c344934514223a36f" . "edd9e810a"]);
            $_85bb20f5360a9a5d29f250748db53ac0->whereOr($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_28fd57f750dbb5ffb3ff" . "ad3a888358a9"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_9ecb1a728fdb50fbae45" . "81f824a09366"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_af0b72c3" . "449345142" . "23a36fedd" . "9e810a"] . $_206f063cdbd5801a283704ef0c883699 . $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_af0b72c344934514223a36fedd9e810" . "a"]);
            $_d88b50ddb42db648a9c7ac08065b9409->addNestedWhereQuery($_85bb20f5360a9a5d29f250748db53ac0, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_fa0ea3ff84d62d9eb5c8e215c" . "e912e57"]);
        }
        return $_d88b50ddb42db648a9c7ac08065b9409->get();
    }
    public function FindOrganization(int $organizationId) : ?Organization
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["i" . "d"], $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_bb152d3d0f3a7af77c042dab184b954" . "5"], $organizationId);
        $_3fd75875d0e1e227000060b324e3b7ef = $_d88b50ddb42db648a9c7ac08065b9409->get();
        if ($_3fd75875d0e1e227000060b324e3b7ef->count() === 0) {
            return null;
        }
        
        
        return $_3fd75875d0e1e227000060b324e3b7ef->first();
    }
    public function FindOrganizationIdByGroupId(int $groupId) : int
    {
        $_d88b50ddb42db648a9c7ac08065b9409 = $this->mapper->query();
        $_d88b50ddb42db648a9c7ac08065b9409->where($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_ed08d8887622a4071ac79" . "b3c5329659d"], $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_bb152d3d0f3a7af77c042" . "dab184b9545"], $groupId);
        $_3fd75875d0e1e227000060b324e3b7ef = $_d88b50ddb42db648a9c7ac08065b9409->get();
        if ($_3fd75875d0e1e227000060b324e3b7ef->count() === 0) {
            return 0;
        }
        
        
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $_3fd75875d0e1e227000060b324e3b7ef->first();
        return $_abefe39a00d9d468aa7aa7ee9ca696e0->id;
    }
    public function DeleteOrganization(Organization $_abefe39a00d9d468aa7aa7ee9ca696e0)
    {
        $this->mapper->delete($_abefe39a00d9d468aa7aa7ee9ca696e0);
    }
    
    
    
    
    
    
    public function GetAvailableGroups(SecurityContext $context, int $_4334e3c9df4ec41b45044fed86657252 = self::GROUP_VISIBILITY_MINE) : array
    {
        
        
        $_4a59b205eee4ba785cff6fa015a000f4 = Services::I()->{UserGroupService::class};
        
        
        $groupRepo = Services::I()->{GroupRepository::class};
        $_696eb5a0ef41a928671b399093f8e3d7 = $this->all();
        $_8972050331ba380fdf80d3afd7cea936 = [];
        foreach ($_696eb5a0ef41a928671b399093f8e3d7 as $_c44da449b8b4828cbe269cac8a34341f) {
            $_ccffadd43bc75166d819c9bd2a0f053a = $_4a59b205eee4ba785cff6fa015a000f4->GetAllSubgroups([$_c44da449b8b4828cbe269cac8a34341f->group_id]);
            $_8972050331ba380fdf80d3afd7cea936 = $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_f73dab6066" . "30b388645c4" . "f7d3fbb13bb"]($_8972050331ba380fdf80d3afd7cea936, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_d706c160e45bf7" . "434fff82a5976f0" . "e19"]($_ccffadd43bc75166d819c9bd2a0f053a));
        }
        $_d88b50ddb42db648a9c7ac08065b9409 = $groupRepo->query()->whereNotIn($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_fd3573b00e549f334fe5f4" . "d7536a53ca"], $_8972050331ba380fdf80d3afd7cea936);
        if ($_4334e3c9df4ec41b45044fed86657252 === self::GROUP_VISIBILITY_MINE) {
            $_03e9164d0a343b742df4793268b80767 = new GroupFilter($context);
            $_03e9164d0a343b742df4793268b80767->SetFilterByExtranet(true);
            $_3076cfb1b03de41ca22393abbf2ef426 = $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_d706c160e45bf7434fff82a5976" . "f0e19"]($groupRepo->GetGroupsByUserId($_03e9164d0a343b742df4793268b80767, $context->GetUserId()));
            $_14e7d5dee412ccf516939d1e99c87733 = $groupRepo->GetAllSubgroups($_3076cfb1b03de41ca22393abbf2ef426);
            $_d88b50ddb42db648a9c7ac08065b9409->whereIn($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_fd3573b00e549f3" . "34fe5f4d7536a53c" . "a"], $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_d706c160e45bf7434fff82a" . "5976f0e19"]($_14e7d5dee412ccf516939d1e99c87733));
        }
        $_14e7d5dee412ccf516939d1e99c87733 = $_d88b50ddb42db648a9c7ac08065b9409->get([$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_fd3573b00e549f3" . "34fe5f4d7536a53c" . "a"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_23d5931807d1bdde4e2c5" . "b3adcc4f09d"]]);
        $_be18d044f62ce168d3312b5e79678a18 = [];
        foreach ($_14e7d5dee412ccf516939d1e99c87733 as $group) {
            $_be18d044f62ce168d3312b5e79678a18[$group[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_fd3573b00e549f334fe5f4d7536a5" . "3ca"]]] = $group[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_23d5931807d1bdde4e2c5b3" . "adcc4f09d"]];
        }
        return $_be18d044f62ce168d3312b5e79678a18;
    }
    public function CanUserViewOrganization(SecurityContext $context, int $organizationId) : bool
    {
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $this->FindOrganization($organizationId);
        if ($_abefe39a00d9d468aa7aa7ee9ca696e0 === null) {
            return false;
        }
        
        
        $permissions = Services::I()->{Permissions::class};
        return $permissions->CanViewThisOrganization($context, $_abefe39a00d9d468aa7aa7ee9ca696e0->group_id);
    }
    public function CanUserManageOrganization(SecurityContext $context, int $organizationId) : bool
    {
        
        
        $permissions = Services::I()->{Permissions::class};
        if ($organizationId === 0) {
            
            
            return $permissions->CanManageOrganizations($context);
        }
        $_abefe39a00d9d468aa7aa7ee9ca696e0 = $this->FindOrganization($organizationId);
        if ($_abefe39a00d9d468aa7aa7ee9ca696e0 === null) {
            return false;
        }
        return $permissions->CanManageThisOrganization($context, $_abefe39a00d9d468aa7aa7ee9ca696e0->group_id);
    }
}