(function () {
	'use strict';

    var ng_module_name = 'pageurl_list';

	angular.module(ng_module_name)
		.directive('deleteSite', deleteSite);

	deleteSite.$inject = ['pageurlListService', 'trashcanPreloadFactory'];
	function deleteSite(pageurlListService, trashcanPreloadFactory)
	{
		return {
			replace: false,
			restrict: 'E',
			controller: controller,
			controllerAs: 'deleteSite',
			templateUrl: '/intranet/pages/html/includes/delete_site.directive.html'
		};

		function controller()
		{
			var ctrl = this;
			ctrl.data = {};
			ctrl.data.csrf_token = angular.element('#csrf_token').val();
			ctrl.data.numChildren = 0;

            ctrl.deleteSiteMessage = trashcanPreloadFactory.deleteSiteMessage;
            ctrl.siteUrlReservedMessage = trashcanPreloadFactory.siteUrlReservedMessage;

			ctrl.init = function(data, site_perms)
			{
				ctrl.data.url = data.url;
				ctrl.data.title = data.title;
				ctrl.data.canDelete = site_perms.canDeleteSite;
			};

			ctrl.show = function()
			{
				var pageurls = pageurlListService.getUrls();
				ctrl.data.numChildren = 0;
				for (var i = 0; i < pageurls[0].children.length; i++)
				{
					ctrl.data.numChildren++;
					ctrl.data.numChildren += pageurls[0].children[i].children.length;
				}
				angular.element('#deleteSiteModal').modal();
			};

			ctrl.getAction = function()
			{
				return '/pages/' + ctrl.data.url + '/.deletesite';
			}
		}
	}
}());
