(function () {
	'use strict';

    var ng_module_name = 'tile_library';

	angular.module(ng_module_name)
		.directive('tileLibrary', tileLibrary);

	tileLibrary.$inject = ['$timeout'];
	function tileLibrary($timeout)
	{
		return {
			controller: controller,
			controllerAs: 'library',
			link: link,
			replace: false,
			restrict: 'E',
			scope: {
			    categories: '=',
				tiles: '=',
				control: '='
			},
			templateUrl: '/intranet/pages/html/includes/tile_library.html'
		};

		/** directive controller */
		function controller($scope)
		{
			var ctrl = this;

            this.$onInit = function() {
                ctrl.categories = $scope.categories;
                ctrl.tiles = $scope.tiles;
            };

			ctrl.view = 'grid';
			ctrl.viewTiles = [];

			ctrl.keywords = '';
			ctrl.category_filter = undefined;

			ctrl.setVisibleTiles = setVisibleTiles;
			ctrl.clicked = clicked;
			ctrl.SetCategoryFilter = SetCategoryFilter;

            function setVisibleTiles() {
                $('.js-component-tile').tooltip('hide');

                while (ctrl.viewTiles.length > 0) {
                    ctrl.viewTiles.pop();
                }

                for (var i = 0; i < ctrl.tiles.length; i++) {
                    if (typeof ctrl.category_filter !== 'undefined') {
                        var tile_in_category = false;
                        for (var category_offset in ctrl.tiles[i].categories) {
                            if (ctrl.category_filter === ctrl.tiles[i].categories[category_offset]) {
                                tile_in_category = true;
                                break;
                            }
                        }

                        if (tile_in_category === false) {
                            continue;
                        }
                    }

                    if (ctrl.keywords !== '') {
                        var search_string = ctrl.keywords.toLowerCase();
                        if ((ctrl.tiles[i].title.toLowerCase().indexOf(search_string) === -1) &&
                            (ctrl.tiles[i].application.toLowerCase().indexOf(search_string) === -1) &&
                            (ctrl.tiles[i].description.toLowerCase().indexOf(search_string) === -1)) {
                            continue;
                        }
                    }

                    ctrl.viewTiles.push(ctrl.tiles[i]);
                }
            }

			function clicked ($event, tile)
			{
				$event.preventDefault();

				var link = $($event.currentTarget);
				if (!link.has('.js-new_tile_link'))
					link = $($event.currentTarget).closest('.js-new_tile_link');

				link.parent().tooltip('hide');

				angular.element($event.currentTarget).trigger({type: 'add-new-tile', tile: tile});
			}

            function SetCategoryFilter(category) {
                ctrl.category_filter = category;
                ctrl.setVisibleTiles();
            }

            // ToDo: Remove these lines when a Claro >= 8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
		}

		function link(scope, iElement, iAttrs, ctrl)
		{
			scope.internalControl = scope.control || {};
			scope.internalControl.reset = function()
			{
				ctrl.keywords = '';
				ctrl.setVisibleTiles();
				$timeout(function()
				{
					scope.$digest();

					// Auto-focus the filter on most browsers. IE10 and 11 hide the placeholder when focused so not there
					// note. Nasty capability check to test for not IE10 or IE11. Better than version string sniffing though
					if ((document.body.style['msScrollSnapPointsX'] == undefined) &&
						(document.body.style['msTextCombineHorizontal'] == undefined))
					{
						angular.element(iElement).find('.js-library-keywords').focus();
					}
				}, 0);
			}
		}
	}
}());
