<?php
namespace Claromentis\Pages\UseCase;

$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"] = (@$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"] ?: array()) + array("_f6ab5a050196eebba1afb" . "107ad0143d0" => base64_decode("Y2hlY2tvdXQ" . "="), "_d1de6d14d3d23" . "752c1f51753f40" . "3b72e" => base64_decode("Y2hlY2" . "tpbg=="), "_8142def44b242bc756" . "c812f4ab96a3ea" => base64_decode("VGhlIHBhZ2UgaXMgbm90IGNoZWNrZWQgb3V0IC0gbm90aGluZ" . "yB0byBwdWJsaXNo"), "_017e0023" . "480ae2b40" . "6f84af6c6" . "6f5110" => base64_decode("UGFnZSBjaGVj" . "a2VkIG91dA=="), "_e167da360aa15da9eefff030" . "749f85ef" => base64_decode("VGhlIHVwZGF0ZWQgcGFnZSBjb250ZW50IGlzIHB1Y" . "mxpc2hlZA=="), "_3f05c7e033d5fa5883b27e9248e" . "3ab53" => base64_decode("cGFnZX" . "M="), "_f7e58afec3ec8739e03ac554a75d" . "1ffa" => base64_decode("UGFnZSBlZGl0aW5nIGNhbmNlbG" . "xlZA=="));
use Claromentis\Core\Audit\Audit;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Pages\Exception\AccessDeniedException;
use Claromentis\Pages\Exception\InvalidObjectStateException;
use Claromentis\Pages\Exception\WorkingCopyExistsException;
use Claromentis\Pages\Facade\Drafts;
use Claromentis\Pages\Lock\LockService;
use Claromentis\Pages\Model\Page;
use Claromentis\Pages\Model\PageUrl;
use Claromentis\Pages\PagesAcl;
use Claromentis\Pages\Search\Indexing\PageIndexing;
use Claromentis\Search\Indexing\IndexingQueue;




class CheckoutPublish
{
    protected $drafts;
    protected $acl;
    protected $locks;
    protected Audit $audit;
    public function __construct(Drafts $_ca650641449d5d94bb77fc46da77ed8a, PagesAcl $acl, LockService $_9cd4b2152729fd679e63852ebc623594, Audit $audit)
    {
        $this->drafts = $_ca650641449d5d94bb77fc46da77ed8a;
        $this->acl = $acl;
        $this->locks = $_9cd4b2152729fd679e63852ebc623594;
        $this->audit = $audit;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Publish(SecurityContext $security, PageUrl $page_url)
    {
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if (!$this->acl->CanEditPage($security, $_8c02736ffb2efc1d69d2c9a2a34e7294)) {
            throw new AccessDeniedException();
        }
        
        
        $this->locks->Lock($page_url->id, $security->GetUserId());
        if (!$_8c02736ffb2efc1d69d2c9a2a34e7294) {
            throw new InvalidObjectStateException($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_8142def44b242bc756c81" . "2f4ab96a3ea"]);
        }
        $this->drafts->Publish($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294, $security);
        $this->locks->Release($page_url->id, $security->GetUserId());
        $this->audit->Success($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_3f05c7e033d5" . "fa5883b27e924" . "8e3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_d1de6d14d3d2375" . "2c1f51753f403b72" . "e"], $page_url->id, $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_e167da360aa15da" . "9eefff030749f85e" . "f"]);
        IndexingQueue::Reindex(PageIndexing::TYPE_NAME, $page_url->id);
    }
    
    
    
    
    
    
    
    
    
    
    public function GetWorkingCopy(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        return $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Checkout(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $this->locks->Lock($page_url->id, $security->GetUserId());
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            throw new WorkingCopyExistsException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->CreateWorkingCopy($page_url, $security->GetUserId());
        $this->drafts->DeleteWorkingCopiesExcept($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        $this->audit->Success($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_3f05c7e033d5fa5883b27e" . "9248e3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_f6ab5a050196eebb" . "a1afb107ad0143d0"], $page_url->id, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_017e0023480" . "ae2b406f84af" . "6c66f5110"]);
        return $_8c02736ffb2efc1d69d2c9a2a34e7294;
    }
    
    
    
    
    
    
    
    
    public function CancelEditing(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            $this->drafts->DeleteWorkingCopy($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        }
        $this->audit->Failure($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_3f05c7e033d5" . "fa5883b27e924" . "8e3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_f6ab5a050196eebba1" . "afb107ad0143d0"], $page_url->id, $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_f7e58afec3ec87" . "39e03ac554a75d1" . "ffa"]);
        $this->locks->Release($page_url->id, $security->GetUserId());
    }
}