define(['jquery', 'cla_select2'], function($)
{
	var NewSite = function()
	{
		this.init();
	};

	NewSite.prototype.init = function()
	{
		var self = this;
		$('#new_site').on('click', function(evt)
		{
			$('#siteCreateModal').modal();
			evt.preventDefault();

			var source_new = $('#source_new');
			var source_copy = $('#source_copy');
			var pick_site = $('#pick_site');
			var copy_perms = $('#copy_perms');

			source_new.prop('checked', true);
			pick_site.hide();

			self.setPreviewLink();

			var site_picker = $('#copyable_sites');
			site_picker.select2();

			source_new.on('change', function()
			{
				pick_site.hide();
			});

			source_copy.on('change', function()
			{
				pick_site.show();
			});

			site_picker.on('change', function(evt)
			{
				self.setPreviewLink($(this).val());
			});

			$('#create_site').on('click', function(evt)
			{
				evt.preventDefault();

				var url = '/pages/.newsite';

				var do_copy_perms = copy_perms.prop('checked') ? 1 : 0;


				if ($('input[name=source]:checked').val() === 'copy')
				{
					url += "?source=" + site_picker.val() + '&do_copy_perms=' + do_copy_perms;
				}

				window.location = url;
			});
		});
	};

	NewSite.prototype.setPreviewLink = function()
	{
		$('#site_preview').prop('href', $('#copyable_sites').val());
	};

	return NewSite;
});