/**
 *
 * A service to provide navigation data for a page
 *
 */


(function () {
	'use strict';

    var ng_module_name = 'page_navigation';

	angular.module(ng_module_name)
		.service('pageNavigationService', pageNavigationService);

	function pageNavigationService()
	{
		var service = this;
		service.navData = [];

		service.setNavigationData = function(navData)
		{
			// Set data without breaking the reference.
			service.navData.length = 0;
			angular.merge(service.navData, navData);
		};

		service.getNavigationData = function()
		{
			return service.navData;
		};
	}
}());