(function ()
{
	'use strict';

    var ng_module_name = 'tile_settings';

	angular.module(ng_module_name)
		.controller('tileButtonsController', settings_controller);

	settings_controller.$inject = ['$timeout', 'tileLibraryService'];
	function settings_controller($timeout, tileLibraryService)
	{
		var ctrl = this;
		ctrl.tile_id = 0;
		ctrl.tile = {};
		ctrl.tileType = '';
		ctrl.width = 'small';

		ctrl.hasOptions = false;

		ctrl.init = function(tile_id)
		{
			tileLibraryService.getTiles();

			$timeout(function()
			{
				ctrl.tile_id = tile_id;
				ctrl.tile = cla.pages.tileCollection.getTileById(ctrl.tile_id);

				if (typeof ctrl.tile.options === 'undefined')
					ctrl.hasOptions = false;
				else
				{
					ctrl.hasOptions =  Object.keys(ctrl.tile.options).length > 0;

					for (var option in ctrl.tile.options)
					{
						if (ctrl.tile.options.hasOwnProperty(option))
						{
							if (ctrl.tile.options[option].width === 'large')
								ctrl.width = 'large';
							if ((ctrl.tile.options[option].width === 'medium') &&
								(ctrl.width !== 'large'))
							{
								ctrl.width = 'medium';
							}
						}
					}
				}

				ctrl._getTitle();
			}, 10);
		};

		ctrl._getTitle = function()
		{
			if (!tileLibraryService.isLoading)
				ctrl.tileType = tileLibraryService.getTileTitle(ctrl.tile.type);
			else
				$timeout(ctrl._getTitle, 50);
		};

		ctrl.onOpenPopover = function()
		{
			// Stop all tiles from being draggable
			cla.pages.disableTileMoving();
			// Only reset a user or group picker
			for (var options in ctrl.tile.options)
			{
				if (ctrl.tile.options.hasOwnProperty(options))
				{
					if (ctrl.tile.options[options].input === 'user_picker')
						ctrl.tile.options[options].token.reset();
					if (ctrl.tile.options[options].input === 'group_picker')
						ctrl.tile.options[options].token.reset();
					if (ctrl.tile.options[options].input === 'role_picker')
						ctrl.tile.options[options].token.reset();
					if (ctrl.tile.options[options].input === 'folder_picker')
                        ctrl.tile.options[options].token.reset();
                    if (ctrl.tile.options[options].input === 'document_picker')
                    {
                        if (typeof ctrl.tile.options[options].token !== 'undefined') {
                            ctrl.tile.options[options].token.reset();
                        }
                    }
					if (ctrl.tile.options[options].input === 'image_picker')
					{
						if (typeof ctrl.tile.options[options].token !== 'undefined')
							ctrl.tile.options[options].token.reset();
					}
					if (ctrl.tile.options[options].input === 'html_editor')
						ctrl.tile.options[options].token.onOpen();
				}
			}

			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .tile-settings').addClass('settings-open');
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .js-settings_app').addClass('active-settings-popover');

			/*var editors = angular.element('[data-tile_id="' + ctrl.tile_id + '"] .tile-settings .js-html-editor textarea');
			if (editors.length > 0)
			{
				editors.each(function()
				{
					var editorObj = angular.element(this).data('ckeditor');
					if (editorObj !== undefined)
					{
						editorObj.removeAllListeners();
						CKEDITOR.remove(editorObj);
					}

					editorObj = ctrl.ckeditor = window.CKEDITOR.replace(this);
					angular.element(this).data('ckeditor', editorObj);
					editorObj.on('pasteState', function()
					{
						angular.element(this).html(editorObj.getData());
						angular.element(this).trigger('change');
					});
				});
			}*/
		};

		ctrl.onClosePopover = function()
		{
			// Allow tiles to be draggable
			cla.pages.enableTileMoving();

			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .tile-settings').removeClass('settings-open');
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .js-settings_app').removeClass('active-settings-popover');

			for (var options in ctrl.tile.options)
			{
				if (ctrl.tile.options.hasOwnProperty(options))
				{
					if (ctrl.tile.options[options].input === 'html_editor')
						ctrl.tile.options[options].token.onClose();
				}
			}
		};

		ctrl.onOpenDeletePopover = function()
		{
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .tile-settings').addClass('delete-open');
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .js-delete-button').addClass('delete-open');
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .js-settings_app').addClass('active-settings-popover');
		};

		ctrl.onCloseDeletePopover = function()
		{
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .tile-settings').removeClass('delete-open');
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .js-delete-button').removeClass('delete-open');
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .js-settings_app').removeClass('active-settings-popover');
		};

		ctrl.showOptions = function()
		{
			return ctrl.hasOptions;
		};

		ctrl.cancelDelete = function()
		{
			angular.element('[data-tile_id="' + ctrl.tile_id + '"] .js-delete-trigger').click();
		};
	}
}());
