define (['jquery'], function($) {

    var RecentlyDeleted = function () {
        var self = this;
        // Handler for the buttons on top
        $('.deleted_type_tab').on('click', function() {
            var viewTypes = ['myItems', 'allItems'];

            // This click handler is fired before the components update, so we have to wait for it to propagate.
            // A change event would be better but there isn't one
            setTimeout(function() {

                var oldView = self.view;
                for (var i = 0; i < viewTypes.length; i++)
                {
                    if ($('.deleted_type_tab[name="' + viewTypes[i] + '"]').hasClass('active'))
                        self.view = viewTypes[i];
                }
                if (self.view !== oldView)
                    self.updateView();
            }, 0);
        });

        $('#deleted_items_container').on('change', '.deleted_items_check_everything', function() {
            if ($(this).prop('checked'))
                $(this).closest('table').find('.js-checkbox').prop('checked', true);
            else
                $(this).closest('table').find('.js-checkbox').prop('checked', false);
        });

        $('#deleted_items_container').on('change', '.js-checkbox', function() {
            var table = $(this).closest('table');

            var boxes = table.find('.js-checkbox');
            var numChecked = 0;
            var numBoxes = boxes.length;
            for (var i = 0; i < boxes.length; i++) {
                if ($(boxes[i]).prop('checked'))
                    numChecked++;
            }

            if (numBoxes > numChecked)
                table.find('.deleted_items_check_everything').prop('checked', false);
            else
                table.find('.deleted_items_check_everything').prop('checked', true);
        });
    };

    RecentlyDeleted.prototype.view = 'myItems';


    return RecentlyDeleted;
});
