/**
 *
 * A service to coordinate the add link modal between 2 directives.
 * It holds new link data that is shared to both of them and allows them to notify each other.
 *
 */


(function () {
	'use strict';

    var ng_module_name = 'site_link';

	angular.module(ng_module_name)
		.service('siteLinkService', siteLinkService);

	function siteLinkService()
	{
		var service = this;
		service.displayCallback = null;
		service.submitCallback = null;
		service.data = {};

		service.resetData = function()
		{
			service.data.id = 0;
			service.data.parent_id = 0;
			service.data.parent_name = '';
			service.data.title = '';
			service.data.url = '';
			service.data.new_window = true;
		};

		service.registerDisplayCallback = function(callback)
		{
			service.displayCallback = callback;
		};

		service.registerSubmitCallback = function(callback)
		{
			service.submitCallback = callback;
		};

		service.show = function()
		{
			if (service.displayCallback !== null)
				service.displayCallback();
		};

		service.submit = function()
		{
			var data = {
				id: service.data.id,
				parent_id: service.data.parent_id,
				title: service.data.title,
				url: service.data.url,
				new_window: service.data.new_window
			};
			if (service.submitCallback !== null)
				service.submitCallback(data);
		};

		service.setNewData = function(pageurl, site_name)
		{
			service.data.id = 0;
			service.data.parent_id = pageurl.id;
			if (pageurl.level > 0)
				service.data.parent_name = pageurl.title;
			else
				service.data.parent_name = site_name;

			service.data.title = '';
			service.data.url = '';
			service.data.new_window = true;
		};

		service.setEditData = function(pageurl, site_name)
		{
			service.data.id = pageurl.id;
			service.data.parent_id = pageurl.parent_id;
			service.data.parent_name = site_name;

			service.data.title = pageurl.title;
			service.data.url = pageurl.link_url;
			service.data.new_window = pageurl.new_window;
		};

		service.resetData();
	}
}());