<?php
namespace Claromentis\Pages\UseCase;

$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"] = (@$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"] ?: array()) + array("_8142def44b242bc75" . "6c812f4ab96a3ea" => base64_decode("VGhlIHBhZ2UgaXMgbm90IGNoZWNrZWQgb3V0IC0g" . "bm90aGluZyB0byBwdWJsaXNo"), "_017e0023480ae" . "2b406f84af6c66" . "f5110" => base64_decode("UGFnZSBjaGV" . "ja2VkIG91dA" . "=="), "_3f05c7e033d5fa5883b" . "27e9248e3ab53" => base64_decode("cGF" . "nZX" . "M="), "_d1de6d14d3d23752c1f5" . "1753f403b72e" => base64_decode("Y2hlY2tpbg=" . "="), "_f6ab5a050196ee" . "bba1afb107ad014" . "3d0" => base64_decode("Y2hlY2tvdXQ" . "="), "_f7e58afec3ec8739e" . "03ac554a75d1ffa" => base64_decode("UGFnZSBl" . "ZGl0aW5n" . "IGNhbmNl" . "bGxlZA=="), "_e167da360aa15da9eefff03074" . "9f85ef" => base64_decode("VGhlIHVwZGF0ZWQgcGFnZSB" . "jb250ZW50IGlzIHB1Ymxpc2" . "hlZA=="));
use Claromentis\Core\Audit\Audit;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Pages\Exception\AccessDeniedException;
use Claromentis\Pages\Exception\InvalidObjectStateException;
use Claromentis\Pages\Exception\WorkingCopyExistsException;
use Claromentis\Pages\Facade\Drafts;
use Claromentis\Pages\Lock\LockService;
use Claromentis\Pages\Model\Page;
use Claromentis\Pages\Model\PageUrl;
use Claromentis\Pages\PagesAcl;
use Claromentis\Pages\Search\Indexing\PageIndexing;
use Claromentis\Search\Indexing\IndexingQueue;




class CheckoutPublish
{
    protected $drafts;
    protected $acl;
    protected $locks;
    protected Audit $audit;
    public function __construct(Drafts $_ca650641449d5d94bb77fc46da77ed8a, PagesAcl $acl, LockService $_9cd4b2152729fd679e63852ebc623594, Audit $audit)
    {
        $this->drafts = $_ca650641449d5d94bb77fc46da77ed8a;
        $this->acl = $acl;
        $this->locks = $_9cd4b2152729fd679e63852ebc623594;
        $this->audit = $audit;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Publish(SecurityContext $security, PageUrl $page_url)
    {
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if (!$this->acl->CanEditPage($security, $_8c02736ffb2efc1d69d2c9a2a34e7294)) {
            throw new AccessDeniedException();
        }
        
        
        $this->locks->Lock($page_url->id, $security->GetUserId());
        if (!$_8c02736ffb2efc1d69d2c9a2a34e7294) {
            throw new InvalidObjectStateException($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8142def44b242bc756c812f4" . "ab96a3ea"]);
        }
        $this->drafts->Publish($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294, $security);
        $this->locks->Release($page_url->id, $security->GetUserId());
        $this->audit->Success($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_3f05c7e033d" . "5fa5883b27e9" . "248e3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_d1de6d14d3d23752c1f51753" . "f403b72e"], $page_url->id, $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_e167da360aa15da9eefff0307" . "49f85ef"]);
        IndexingQueue::Reindex(PageIndexing::TYPE_NAME, $page_url->id);
    }
    
    
    
    
    
    
    
    
    
    
    public function GetWorkingCopy(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        return $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Checkout(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $this->locks->Lock($page_url->id, $security->GetUserId());
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            throw new WorkingCopyExistsException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->CreateWorkingCopy($page_url, $security->GetUserId());
        $this->drafts->DeleteWorkingCopiesExcept($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        $this->audit->Success($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_3f05c7e033d5fa5883b27e92" . "48e3ab53"], $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_f6ab5a050196eebb" . "a1afb107ad0143d0"], $page_url->id, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_017e0023480ae2b406f84af6c66f5" . "110"]);
        return $_8c02736ffb2efc1d69d2c9a2a34e7294;
    }
    
    
    
    
    
    
    
    
    public function CancelEditing(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            $this->drafts->DeleteWorkingCopy($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        }
        $this->audit->Failure($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_3f05c7e033d5fa58" . "83b27e9248e3ab53"], $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_f6ab5a050196eebba1afb107" . "ad0143d0"], $page_url->id, $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_f7e58afec3ec8739e03ac554a75d1f" . "fa"]);
        $this->locks->Release($page_url->id, $security->GetUserId());
    }
}