function generateSlug(title) {
	var length_limit = 40;

	var rus = {'а':'a', 'б':'b', 'в':'v', 'г':'g', 'д':'d', 'е':'e', 'ё':'jo', 'ж':'zh', 'з':'z', 'и':'i', 'й':'j', 'к':'k', 'л':'l', 'м':'m', 'н':'n', 'о':'o', 'п':'p', 'р':'r', 'с':'s', 'т':'t', 'у':'u', 'ф':'f', 'х':'h', 'ц':'c', 'ч':'ch', 'ш':'sh', 'щ':'sch', 'ъ':'', 'ы':'y', 'ь':'', 'э':'e', 'ю':'ju', 'я':'ja'};
	var pattern = /[^a-zA-Z0-9_]/g;

	title = title.toLowerCase();
	var slug  = '';
	for (var i = 0; i < title.length; i++)
	{
		var charact = title.substring(i, i + 1);
		if (rus[charact])
			slug += rus[charact];
		else
			slug += charact;
	}

	if (slug.match(pattern))
		slug = slug.replace(pattern, "_");

	if (slug.length > length_limit)
		slug = slug.substring(0, length_limit);

	return slug;
}

$(document).ready(function()
{
	// While this is false, editing the title can generate the address
	var addressFixed = false;

	$('#site_title').on('keyup', function()
	{
		if (!addressFixed)
		{
			$('#site_url').val(generateSlug($(this).val()));
		}
	});

	$('#site_url').on('keyup', function()
	{
		addressFixed = true;
	});
});