<?php
namespace Claromentis\Pages;

$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] ?: array()) + array("_3a8ca761206e525598c65fbe81" . "f34fde" => base64_decode("cGFnZXNfc2l0" . "ZQ=="), "_c0deb9b2dfb1f051" . "4346396b78458530" => base64_decode("cGFnZXNfc2l0ZS5pZ" . "A=="), "_4d707fab9" . "3bebb00bbe" . "69e8159697" . "c90" => base64_decode(""), "_3c4ddc372fc520e813cf6dde" . "f604313c" => base64_decode("cA=" . "="), "permissio" . "ns" => base64_decode("cGVybWlz" . "c2lvbnM="), "_dd63e9d94ef9f220789ba002" . "87ea881a" => base64_decode("cHA" . "="), "_98b8bed5ac84335" . "016322c401873c3d" . "4" => base64_decode("UGVybUNoZW" . "NrQXNUd29T" . "UUw="), "_f768b53ccd" . "cd6d1af3142" . "d2183e4f183" => base64_decode("cHAua" . "WQ="));
use Claromentis\Core\Acl\Acl;
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\Exception\AclException;
use Claromentis\Core\DAL;
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Pages\Model\MenuItem;
use Claromentis\Pages\Model\Page;
use Claromentis\Pages\Model\PageUrl;
use Claromentis\Pages\Model\Site;
use Claromentis\Pages\Model\Tile;
use Claromentis\Pages\Repository\MenuItemRepository;
use Claromentis\Pages\Repository\PagesRepository;
use Claromentis\Pages\Repository\UrlRepository;




class PagesAcl
{
    protected $acl_repository;
    protected $url_repo;
    protected $pages_repo;
    public function __construct(AclRepository $acl, UrlRepository $_4fd544a0039d23957d8ced73ba74acb9, PagesRepository $pages_repo)
    {
        $this->acl_repository = $acl;
        $this->url_repo = $_4fd544a0039d23957d8ced73ba74acb9;
        $this->pages_repo = $pages_repo;
    }
    public function CanCreateLink(SecurityContext $context, $_a1053c2fc8090400c07497f8420a3587)
    {
        $_720c0c64bd5b02debfb65448083be0bf = $this->pages_repo->GetLatestPageIdForMenuItem($_a1053c2fc8090400c07497f8420a3587);
        return $this->CanEditPageProperties($context, $_720c0c64bd5b02debfb65448083be0bf);
    }
    public function CanCreateSite(SecurityContext $context)
    {
        return $this->acl_repository->Permits($context, Perm::ADD_SITES, Perm::CLASS_SITES_ADMIN, 1);
    }
    public function CanEditSite(SecurityContext $context, $site_id)
    {
        return $this->IsSiteAdmin($context, $site_id);
    }
    public function CanDeleteSite(SecurityContext $context, $site_id)
    {
        return $this->IsSiteAdmin($context, $site_id);
    }
    public function CanViewUrl(SecurityContext $context, $url_id)
    {
        $_720c0c64bd5b02debfb65448083be0bf = $this->pages_repo->GetLatestPageIdForUrl($url_id);
        if ($this->IsSiteAdmin($context, null, $_720c0c64bd5b02debfb65448083be0bf)) {
            return true;
        }
        return $this->acl_repository->Permits($context, Perm::PAGE_VIEW, Perm::CLASS_PAGE, $_720c0c64bd5b02debfb65448083be0bf);
    }
    public function CanViewPage(SecurityContext $context, $_720c0c64bd5b02debfb65448083be0bf)
    {
        if ($this->IsSiteAdmin($context, null, $_720c0c64bd5b02debfb65448083be0bf)) {
            return true;
        }
        return $this->acl_repository->Permits($context, Perm::PAGE_VIEW, Perm::CLASS_PAGE, $_720c0c64bd5b02debfb65448083be0bf);
    }
    public function CanDeleteMenuItem(SecurityContext $context, MenuItem $_d43c6db6d25c2749f65bc7bc28bd8df3)
    {
        $url_id = $_d43c6db6d25c2749f65bc7bc28bd8df3->url_id;
        if ($url_id == 0) {
            $url_id = $this->pages_repo->GetNonLinkParentUrl($_d43c6db6d25c2749f65bc7bc28bd8df3->id);
        }
        $_720c0c64bd5b02debfb65448083be0bf = $this->pages_repo->GetLatestPageIdForUrl($url_id);
        return $this->CanEditPageProperties($context, $_720c0c64bd5b02debfb65448083be0bf);
    }
    public function CanMoveChildMenuItems(SecurityContext $context, $_720c0c64bd5b02debfb65448083be0bf)
    {
        return $this->CanEditPageProperties($context, $_720c0c64bd5b02debfb65448083be0bf);
    }
    public function CanShowOrHideMenuItem(SecurityContext $context, MenuItem $_d43c6db6d25c2749f65bc7bc28bd8df3)
    {
        $url_id = $_d43c6db6d25c2749f65bc7bc28bd8df3->url_id;
        if ($url_id == 0) {
            $url_id = $this->pages_repo->GetNonLinkParentUrl($_d43c6db6d25c2749f65bc7bc28bd8df3->id);
        }
        $_720c0c64bd5b02debfb65448083be0bf = $this->pages_repo->GetLatestPageIdForUrl($url_id);
        return $this->CanEditPageProperties($context, $_720c0c64bd5b02debfb65448083be0bf);
    }
    
    
    
    
    
    
    
    
    
    public function CanEditDraft(SecurityContext $security, PageUrl $page_url)
    {
        return $this->CanEditPageProperties($security, $page_url->latest_page_id);
    }
    
    
    
    
    
    
    
    
    
    public function CanEditPage(SecurityContext $security, Page $_221da17e3055fae8d3ff516b832a5f3b)
    {
        if (!$_221da17e3055fae8d3ff516b832a5f3b->is_draft || $_221da17e3055fae8d3ff516b832a5f3b->editor_id != $security->GetUserId()) {
            return false;
        }
        if ($this->IsSiteAdmin($security, null, $_221da17e3055fae8d3ff516b832a5f3b->id)) {
            return true;
        }
        $_5fdf10084135f372540117b2d9fb79fb = $this->pages_repo->GetLatestPageIdForUrl($_221da17e3055fae8d3ff516b832a5f3b->url_id);
        return $this->CanEditPageProperties($security, $_5fdf10084135f372540117b2d9fb79fb);
    }
    
    
    
    
    
    
    
    public function CanEditPageProperties(SecurityContext $context, $_720c0c64bd5b02debfb65448083be0bf)
    {
        if ($this->IsSiteAdmin($context, null, $_720c0c64bd5b02debfb65448083be0bf)) {
            return true;
        }
        return $this->acl_repository->Permits($context, Perm::PAGE_EDIT, Perm::CLASS_PAGE, $_720c0c64bd5b02debfb65448083be0bf);
    }
    
    
    
    
    
    
    
    
    
    public function HasTilePermissions(SecurityContext $security, Tile $tile, $permissions)
    {
        if ($permissions & Perm::PAGE_EDIT) {
            $_221da17e3055fae8d3ff516b832a5f3b = $this->pages_repo->GetById($tile->GetPageId());
            return $this->CanEditPage($security, $_221da17e3055fae8d3ff516b832a5f3b);
        }
        if ($permissions == Perm::PAGE_VIEW) {
            $_221da17e3055fae8d3ff516b832a5f3b = $this->pages_repo->GetById($tile->GetPageId());
            return $this->CanViewPage($security, $_221da17e3055fae8d3ff516b832a5f3b->id);
        }
        return false;
    }
    
    
    
    
    
    
    
    
    public function CanListComponents(SecurityContext $context)
    {
        return $context->GetUserId() > 0;
    }
    
    
    
    
    
    
    
    public function CanViewCategories(SecurityContext $context)
    {
        return $this->CanListComponents($context);
    }
    public function ApplySitesPermissions(SecurityContext $context, DAL\QueryBuilder $_4c8189237e0d0b5cd82c06d69613c88e, $_a48eb1db4f6ab2c82fb9db687c5f4a32 = Perm::SITE_MANAGE)
    {
        list($_bdfba04e3e7f4c28fa5e00cda2d66752, $_c7598a9614976977e540b17c67707384) = $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_98b8bed5ac84" . "335016322c401" . "873c3d4"](Perm::CLASS_SITE, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_c0deb9b2d" . "fb1f051434" . "6396b78458" . "530"], $_a48eb1db4f6ab2c82fb9db687c5f4a32, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_4d707fab93bebb00bbe69e81" . "59697c90"], $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_3c4ddc372fc" . "520e813cf6dd" . "ef604313c"]);
        
        
        $_4c8189237e0d0b5cd82c06d69613c88e->AddJoin($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_3a8ca761" . "206e52559" . "8c65fbe81" . "f34fde"], $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["per" . "mis" . "sio" . "ns"], $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_3c4ddc372fc520e813cf6ddef60" . "4313c"], $_bdfba04e3e7f4c28fa5e00cda2d66752);
        $_4c8189237e0d0b5cd82c06d69613c88e->AddWhereAndClause($_c7598a9614976977e540b17c67707384);
    }
    public function ApplyPagesPermissions(SecurityContext $context, DAL\QueryBuilder $_4c8189237e0d0b5cd82c06d69613c88e, $_a48eb1db4f6ab2c82fb9db687c5f4a32 = Perm::PAGE_VIEW)
    {
        list($_bdfba04e3e7f4c28fa5e00cda2d66752, $_c7598a9614976977e540b17c67707384) = $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_98b8bed5ac8" . "4335016322c4" . "01873c3d4"](Perm::CLASS_PAGE, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_f768b53ccdcd6d1af31" . "42d2183e4f183"], $_a48eb1db4f6ab2c82fb9db687c5f4a32, $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_4d707fab93bebb00bbe69e8159697" . "c90"], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_3c4ddc372fc520e813cf6ddef604313" . "c"]);
        
        
        $_4c8189237e0d0b5cd82c06d69613c88e->AddJoin($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_dd63e9d94ef9f220789ba002" . "87ea881a"], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["per" . "mis" . "sio" . "ns"], $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_3c4ddc372" . "fc520e813c" . "f6ddef6043" . "13c"], $_bdfba04e3e7f4c28fa5e00cda2d66752);
        $_4c8189237e0d0b5cd82c06d69613c88e->AddWhereAndClause($_c7598a9614976977e540b17c67707384);
    }
    
    
    
    
    
    
    
    
    
    public function SetSiteAcl($site_id, Acl $acl)
    {
        $_00467751a7f02e8265821fee2c132f6e = $acl->CreateCopy(Perm::CLASS_SITE, $site_id);
        $this->acl_repository->Save($_00467751a7f02e8265821fee2c132f6e);
        return $_00467751a7f02e8265821fee2c132f6e;
    }
    public function SetPageAcl($_720c0c64bd5b02debfb65448083be0bf, Acl $acl)
    {
        $_00467751a7f02e8265821fee2c132f6e = $acl->CreateCopy(Perm::CLASS_PAGE, $_720c0c64bd5b02debfb65448083be0bf);
        $this->acl_repository->Save($_00467751a7f02e8265821fee2c132f6e);
        return $_00467751a7f02e8265821fee2c132f6e;
    }
    public function GetPageAcl(int $_720c0c64bd5b02debfb65448083be0bf) : Acl
    {
        return $this->acl_repository->Get(Perm::CLASS_PAGE, $_720c0c64bd5b02debfb65448083be0bf);
    }
    public function GetSiteAcl(int $site_id) : Acl
    {
        return $this->acl_repository->Get(Perm::CLASS_SITE, $site_id);
    }
    public function CanViewSiteContent(SecurityContext $context, Site $_ad6d1395fad94fb16ed12d8007727518)
    {
        $_720c0c64bd5b02debfb65448083be0bf = $this->pages_repo->GetLatestPageIdForUrl($_ad6d1395fad94fb16ed12d8007727518->url_id);
        return $this->CanViewPage($context, $_720c0c64bd5b02debfb65448083be0bf);
    }
    public function CanEditSiteContent(SecurityContext $security, $site_id)
    {
        return $this->IsSiteAdmin($security, $site_id);
    }
    public function CanDeleteSiteContent(SecurityContext $security, $site_id)
    {
        return $this->IsSiteAdmin($security, $site_id);
    }
    public function InheritFromParent($_720c0c64bd5b02debfb65448083be0bf, $_6e38cb9e043a07cd69a1711a6704c62a)
    {
        $acl = $this->GetPageAcl($_6e38cb9e043a07cd69a1711a6704c62a);
        $acl->SetObjectId($_720c0c64bd5b02debfb65448083be0bf);
        $this->SetPageAcl($_720c0c64bd5b02debfb65448083be0bf, $acl);
        return $acl;
    }
    public function IsSiteAdmin(SecurityContext $security, $site_id = null, $_720c0c64bd5b02debfb65448083be0bf = null)
    {
        if ($_720c0c64bd5b02debfb65448083be0bf !== null) {
            $site_id = $this->pages_repo->GetSiteIdForPage($_720c0c64bd5b02debfb65448083be0bf);
        }
        if ($site_id === null) {
            return false;
        }
        return $this->acl_repository->Permits($security, Perm::SITE_MANAGE, Perm::CLASS_SITE, $site_id);
    }
    public function CanAccessSiteTree(SecurityContext $security, $site_id)
    {
        if ($this->IsSiteAdmin($security, $site_id)) {
            return true;
        }
        $_2372fff6e6df76f2cb649f85ba60dd81 = $this->pages_repo->GetPagesForSiteId($site_id);
        foreach ($_2372fff6e6df76f2cb649f85ba60dd81 as $_720c0c64bd5b02debfb65448083be0bf => $_e8b500aea78ceaa49741651ee1a43de2) {
            if ($this->acl_repository->Permits($security, Perm::PAGE_EDIT, Perm::CLASS_PAGE, $_720c0c64bd5b02debfb65448083be0bf)) {
                return true;
            }
        }
    }
}