<?php

use Claromentis\Core\DAL;
use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;
use Claromentis\Pages\Perm;

if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

if (!isset($installer))
	throw new Exception("Install options are not defined");

/** @var \Claromentis\Setup\SetupFacade $installer */
$installer->GetPluginsRepository()->Add('pages', 'Claromentis\Pages\PagesApplication');
$installer->GetAdminPanelCreator()->Enable('pages');

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('pages', 'Pages', '/pages/'));

$db = $installer->GetDb();
$db->query("INSERT INTO pages_site (title, url_id) VALUES ('Main', 0)");
$site_id = $db->insertId();

// allow admin to manage this site
$db->query(
	"INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES
	(int:class, int:site_id, int:oclass, 1, int:rights)",
	Perm::CLASS_SITE,
	$site_id,
	\Claromentis\Core\Acl\PermOClass::INDIVIDUAL,
	Perm::SITE_MANAGE
);

// Add file storage for anything uploaded to the text component CKEditor
$cdn = Claromentis\Core\Services::I()->GetCDN();
if (!$cdn->IsDir('pages_text_component'))
	$cdn->CreateDir('pages_text_component');
$cdn->CreateDir('pages_text_component/images');

$create_tile = function ($tile_info, $page_id) use ($db) {
	$query = new Claromentis\Core\DAL\QueryInsert('pages_tile', [
		'int:page_id' => $page_id,
		'str:class_key' => $tile_info[0],
		'int:x' => $tile_info[1],
		'int:y' => $tile_info[2],
		'int:width' => $tile_info[3],
		'int:height' => $tile_info[4],
	]);
	$db->query($query);
	$tile_id = $db->insertId();

	// save options
	foreach ($tile_info[5] as $key => $value)
	{
		$query = new Claromentis\Core\DAL\QueryInsert('pages_tile_option', [
			'int:tile_id' => $tile_id,
			'str:name' => $key,
			'str:value' => $value,
		]);
		$db->query($query);
	}
};

$create_page = function ($page_url, $title, $tiles_arr, $parent_id, $display_order, $show_nav = 0) use ($db, $create_tile, $site_id) {
	$db->query("INSERT INTO pages_url (full_url, active_page_id, latest_page_id, site_id) VALUES (str:full_url, 0, 0, int:s_id)",
		$page_url, $site_id);
	$url_id = $db->insertId();

	$db->query("INSERT INTO pages_page (title, version, is_draft, url_id, show_title, show_menu) VALUES
		 (str:title, 1, 0, int:url_id, int:show_title, int:show_menu)", $title, $url_id, $show_nav, $show_nav);
	$page_id = $db->insertId();

	$db->query('INSERT INTO pages_menu_item (site_id, parent_id, title, type, url_id, is_visible, display_order) VALUES (int:site_id, int:parent_id, str:title, 1, int:url_id, 1, int:display_order)',
		$site_id, $parent_id, $title, $url_id, $display_order);
	$menu_item_id = $db->insertId();

	$db->query("UPDATE pages_url SET active_page_id=int:pid, latest_page_id=int:pid WHERE id=int:id", $page_id, $page_id, $url_id);

	foreach ($tiles_arr as $tile_info)
	{
		$create_tile($tile_info, $page_id);
	}

	// allow all registered users to view the page
	$db->query(
		"INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES
		(int:class, int:site_id, int:oclass, 1, int:rights)",
		Perm::CLASS_PAGE,
		$page_id,
		\Claromentis\Core\Acl\PermOClass::ALL,
		Perm::PAGE_VIEW
	);

	return [$url_id, $menu_item_id];
};

$create_unsafe_string = function (string $text) use ($db)
{
	$secret = \CryptUtils::GetRandomString();
	$query = new DAL\QueryInsert('pages_unsafe_string', [
		'str:secret' => $secret,
		'clob:content' => $text
	]);
	$db->query($query);
	return $secret . '-' . $db->insertId();
};

//-----------------------------------------------------------------------------------
list($main_url_id, $main_menu_item_id) = $create_page('main', 'Main',
[
	['pages.greeting', 0, 0, 2, 2, [
		'kicker' => $create_unsafe_string('Welcome to your new digital workplace!'),
		'transparent_bg' => 1,
		'text_shade' => 'light'
	]],
	['news.list', 0, 2, 2, 5, [
		'component_title' => 'News Slider',
		'layout' => 'slider'
	]],
	['pages.html', 0, 7, 2, 5, [
		'title' => 'Free Text Component'
	]],
	['discuss.discussion', 0, 12, 2, 7, [
		'header' => 'Discussion',
		'discussion_id' => 1,
		'show_desc_image' => 0
	]],
	['thankyou', 0, 19, 2, 5, [
		'title' => 'Peer Recognition'
	]],
	['whatsnew.list', 0, 24, 2, 5, []],
	['peoplecomponent', 0, 31, 4, 6, []],
	['buttons.buttons', 2, 0, 2, 2, []],
	['calendar.upcoming_events', 2, 2, 1, 5, []],
	['calendar.minicalendar', 2, 7, 1, 5, []],
	['knowledgebase.recent_articles', 2, 12, 1, 7, []],
	['twitter', 2, 20, 1, 10, []],
	['holidays.who_is_out', 3, 2, 1, 5, [
		'show_next_working_day' => 1,
		'group_day_types' => 0,
		'label_type' => 0
	]],
	['policy.awaiting_action', 3, 7, 1, 5, [
		'category' => null
	]],
	['anniversary', 3, 14, 1, 7, [
		'title' => 'Birthdays',
		'metakey' => 'usr_dob',
		'noevents' => 'No upcoming birthdays.'
	]],
	['anniversary', 3, 20, 1, 5, [
		'metakey' => 'usr_date_started'
	]],
	['icdashboard.project_list', 3, 26, 1, 5, []],
], 0, 1);

$db->query("UPDATE pages_site SET url_id=int:url_id WHERE id=int:site_id", $main_url_id, $site_id);

$result = $db->query("SELECT id, style FROM theme_style");
$numRows = $result->numRows();

if ($numRows)
{
	list($id, $json) = $result->fetchRow();
	$layout_options = json_decode($json, true);
} else
{
	$layout_options = [];
}

$layout_options['homepage_layout'] = $main_url_id;

$json = json_encode($layout_options);

if ($numRows)
{
	$db->query("UPDATE theme_style SET style=str:style WHERE id=int:id", $json, $id);
} else
{
	$db->query("INSERT INTO theme_style (style) VALUES (str:style)", $json);
}
