/**
 *
 * A service to coordinate used URLs to warn the user that they are already in use or still in the recycle bin
 *
 */

(function () {
	'use strict';

    var ng_module_name = 'Trashcan';

	angular.module(ng_module_name)
		.service('trashcanService', newPageService);

	function newPageService()
	{
		var service = this;
        service.urls = {};

        service.setUrls = function(urls) {
            // Empty without breaking references
            for (var UrlId in service.urls)
            {
                if (service.urls.hasOwnProperty(UrlId))
                    delete service.urls[UrlId];
            }

            // Copy the entries
            for (UrlId in urls)
            {
                if (urls.hasOwnProperty(UrlId))
                    service.urls[UrlId] = urls[UrlId];
            }

        };

        service.delete = function(id) {
            for (var UrlId in service.urls)
            {
                if ((service.urls.hasOwnProperty(UrlId)) &&
                    (UrlId == id))
                {
                    service.urls[UrlId].is_deleted = true;
                }
            }
        }

        service.add = function(id, parentId, url) {
            service.urls[id] = {
                parent_id: parseInt(parentId),
                url: url,
                is_deleted: false
            };
        }
	}
}());
