<?php
$_db_migration_to = '01.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_components_tables.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

/* We don't have Pages yet to store the homepage variants in so make a table for us to store the design tool layouts.
 * Each template can then just include <component class="ComponentGridLayout" layout="News"> or similar to pull in
 * the right components
 */

$layout_desc = [
	'id' => 'IDENTITY',
	'name' => 'VARCHAR(64)'
];
$db->CreateTable('pages_layout', $layout_desc, true);
// These will probably be fixed until 8.2 (manage layouts and assign via SUGRE)
$db->query('INSERT INTO pages_layout (name) VALUES ("Simple")');
$db->query('INSERT INTO pages_layout (name) VALUES ("News")');
$db->query('INSERT INTO pages_layout (name) VALUES ("Social")');
$db->query('INSERT INTO pages_layout (name) VALUES ("Mixed")');

$pages_desc = [
	'id' => 'IDENTITY',
	'layout_id' => 'INT NOT_NULL',
	'class_key' => 'VARCHAR(255)',
	'x' => 'INT NOT_NULL',
	'y' => 'INT NOT_NULL',
	'width' => 'INT NOT_NULL',
	'height' => 'INT NOT_NULL'
];
$db->CreateTable('pages_component', $pages_desc, true);
// Sprint 1 is just a draggable homepage without add/delete so add some default components to play with
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (1, "HomePageNews", 1, 1, 2, 5)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (1, "announcements_list", 3, 1, 2, 1)');
// "What's new" isn't a component... yet
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (1, "HomePageSurveysList", 3, 2, 2, 2)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (1, "HomePagePollsList", 3, 4, 2, 2)');

$options_desc = [
	'id' => 'IDENTITY',
	'pages_id' => 'INT NOT_NULL',
	'name' => 'VARCHAR(255)',
	'value' => 'VARCHAR(255) NULL'
];
$db->CreateTable('pages_option', $options_desc, true);
$db->query('INSERT INTO pages_option (pages_id, name, value) VALUES (1, "show_tools", "1")');
$db->query('INSERT INTO pages_option (pages_id, name, value) VALUES (1, "show_comments", "2")');
$db->query('INSERT INTO pages_option (pages_id, name, value) VALUES (1, "max_number", "4")');
DB_UPDATE_FILE
);


$migrations->Run('02_news_layout.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Adjust name of announcements component in DB
$db->query('UPDATE pages_component SET class_key = "Announcements" WHERE class_key = "announcements_list"');

// Adjust simple layout to add new "Whats new" component
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (1, "HomePageWhatsNew", 3, 2, 2, 3)');
$db->query('UPDATE pages_component SET height = 8 WHERE id = 1');
$db->query('UPDATE pages_component SET y = 5 WHERE id = 3');
$db->query('UPDATE pages_component SET y = 7 WHERE id = 4');

// "News" layout
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "Announcements", 1, 1, 2, 1)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "Slider", 1, 2, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "Slider", 3, 1, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "HomePageNews", 1, 5, 2, 16)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "CalendarUpcomingEvents", 3, 4, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "KnowledgebaseRecentArticles", 3, 7, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "KnowledgebaseRecentQuestions", 4, 7, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "RSSReader", 3, 10, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "PolicyAwaitingAction", 3, 13, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "HomePageWhatsNew", 3, 19, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "HomePagePollsList", 3, 16, 1, 2)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (2, "HomePageSurveysList", 4, 16, 1, 2)');
DB_UPDATE_FILE
);


$migrations->Run('03_news_layout 2.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Adjust name of announcements component in DB
$db->AlterColumn('pages_option', 'pages_id', 'component_id', 'INT NOT_NULL');

// Add required options
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (13, "metakey", "rss_feeds")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (13, "display", "5")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (7, "key", "homepage_slider")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (8, "key", "fast_access")');
DB_UPDATE_FILE
);


$migrations->Run('04_social_layout.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Add social components
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "Announcements", 1, 1, 2, 1)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "Slider", 1, 2, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "Slider", 3, 1, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "HomePageNews", 1, 5, 2, 16)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "SocialComponent", 1, 21, 2, 4)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "SocialComponent", 1, 25, 2, 4)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "HomePagePollsList", 1, 29, 1, 4)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "HomePageSurveysList", 2, 29, 1, 4)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "InnovateComponentLive", 3, 4, 2, 6)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "Anniversary", 3, 10, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "Anniversary", 3, 13, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "KnowledgebaseRecentArticles", 3, 16, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "KnowledgebaseRecentQuestions", 3, 19, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (3, "ThankYouComponent", 3, 22, 2, 4)');

// Add required options
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (19, "key", "homepage_slider")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (20, "key", "fast_access")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (22, "source_filter", "twitter")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (22, "limit", "10")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (22, "limit_per", "8")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (22, "post_length", "200")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (23, "source_filter", "facebook")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (23, "limit", "10")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (23, "limit_per", "8")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (23, "post_length", "200")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (26, "object_id", "1")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (27, "timeframe", "30 days")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (27, "metakey", "usr_dob")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (27, "noevents", "There are no upcoming birthdays.")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (27, "message", "Happy Birthday!")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (27, "display", "5")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (27, "show_years", "no")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (27, "show_photo", "yes")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (28, "timeframe", "30 days")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (28, "metakey", "usr_date_started")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (28, "noevents", "There are no upcoming anniversaries.")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (28, "message", "Happy Anniversary!")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (28, "display", "5")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (28, "show_years", "yes")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (28, "show_photo", "yes")');
DB_UPDATE_FILE
);


$migrations->Run('05_mixed_layout.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// Add "mixed" layout components
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "Announcements", 1, 1, 2, 1)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "Slider", 1, 2, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "HomePageNews", 1, 5, 2, 5)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "RSSReader", 1, 10, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "HomePagePollsList", 1, 13, 1, 2)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "HomePageSurveysList", 2, 13, 1, 2)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "PeopleComponent", 1, 15, 2, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "Slider", 3, 1, 2, 1)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "CalendarUpcomingEvents", 3, 2, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "MiniCalendar", 4, 2, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "InnovateComponentLive", 3, 5, 2, 6)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "Anniversary", 3, 11, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "Anniversary", 4, 11, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "KnowledgebaseRecentArticles", 3, 14, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "KnowledgebaseRecentQuestions", 4, 14, 1, 3)');
$db->query('INSERT INTO pages_component (layout_id, class_key, x, y, width, height) VALUES (4, "HomePageWhatsNew", 3, 17, 2, 3)');

$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (33, "key", "homepage_slider")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (34, "channels", "1")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (34, "show_tools", "0")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (34, "show_comments", "0")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (34, "max_length", "160")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (34, "max_number", "2")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (35, "display", "5")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (35, "metakey", "rss_feeds")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (38, "limit", "3")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (39, "key", "fast_access")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (40, "limit", "8")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (40, "calid", "")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (41, "name", "my_cal")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (41, "cln_ids", "1")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (42, "object_id", "1")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (43, "timeframe", "30 days")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (43, "metakey", "usr_dob")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (43, "noevents", "There are no upcoming birthdays.")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (43, "message", "Happy Birthday!")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (43, "display", "5")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (43, "show_years", "no")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (43, "show_photo", "yes")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (44, "timeframe", "30 days")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (44, "metakey", "usr_date_started")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (44, "noevents", "There are no upcoming anniversaries.")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (44, "message", "Happy Anniversary!")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (44, "display", "5")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (44, "show_years", "yes")');
$db->query('INSERT INTO pages_option (component_id, name, value) VALUES (44, "show_photo", "yes")');
DB_UPDATE_FILE
);


$migrations->Run('06_install_plugin.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$plugins = $migrations->GetPluginsRepository();
$plugins->Add('pages', 'Claromentis\Pages\PagesApplication');
DB_UPDATE_FILE
);


$migrations->Run('07_rename_tables.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->RenameTable('pages_layout', 'pages_page');
$db->RenameTable('pages_component', 'pages_tile');
$db->RenameTable('pages_option', 'pages_tile_option');

$db->AlterColumn('pages_tile', 'layout_id', 'page_id');
$db->AlterColumn('pages_tile_option', 'component_id', 'tile_id');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.01');
