<?php
$_db_migration_to = '01.03';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_split_slider_tiles.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// 1. Update all sliders that use the default fast access metadata key to use the new fast_access component
$db->query('UPDATE pages_tile SET class_key = str:fast_access WHERE id IN (SELECT tile_id FROM pages_tile_option WHERE value = str:fast_access2)', 'fast_access', 'fast_access');

// 2. Remove options for minicalendar refresh button - it is deprecated.
$db->query('DELETE FROM pages_tile_option WHERE name = str:show_renew', 'show_renew');
DB_UPDATE_FILE
);


$migrations->Run('02_zero_coordinates.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// remove discrepancy between coordinates used by front-end and stored in db - both are zero-based

list($zero_x) = $db->query_row('SELECT COUNT(1) FROM pages_tile WHERE x=0');
// just a safety check - if this migration was already applied earlier or system just installed with updated init.php
if ($zero_x == 0)
	$db->query('UPDATE pages_tile SET x=x-1, y=y-1');

DB_UPDATE_FILE
);


$migrations->Run('03_deleted_tiles.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('pages_tile', 'deleted', 'BOOL NOT_NULL DEFAULT 0');

DB_UPDATE_FILE
);


$migrations->Run('04_page_editor_id.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('pages_page', 'editor_id', 'INT DEFAULT NULL');

DB_UPDATE_FILE
);


$migrations->Run('05_delete_all_drafts.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->query("UPDATE pages_url SET latest_page_id=active_page_id");

$db->query("DELETE FROM pages_page WHERE id NOT IN (SELECT active_page_id FROM pages_url)");
$db->query("DELETE FROM pages_tile WHERE page_id NOT IN (SELECT id FROM pages_page)");
$db->query("DELETE FROM pages_tile_option WHERE tile_id NOT IN (SELECT id FROM pages_tile)");

DB_UPDATE_FILE
);


$migrations->Run('07_pages_lock.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// pages_page
$table_descr = array(
	'url_id'  => "INT NOT_NULL",
	'user_id'  => "INT NOT_NULL",
	'exp_date' => "INT_DATE",
);

$db->CreateTable('pages_lock', $table_descr, true);

DB_UPDATE_FILE
);


$migrations->Run('08_pages_lock_indexes.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->CreateIndex('pages_lock', 'pages_lock_exp_date', 'exp_date');

DB_UPDATE_FILE
);


$migrations->Run('09_slider_rename.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->query('UPDATE pages_tile SET class_key=str:new WHERE class_key eq:str:old', 'slider.slider', 'slider');
$db->query('UPDATE pages_tile SET class_key=str:new WHERE class_key eq:str:old', 'slider.fast_access', 'fast_access');

DB_UPDATE_FILE
);


$migrations->Run('10_option_length.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('pages_tile_option', 'value', 'value', 'VARCHAR_MAX');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.03');
