<?php
$_db_migration_to = '02.02'; // 1.1.0-beta2
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_customcomponent_options.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

$table_params = [
	'id' => 'IDENTITY',
	'component_id' => 'INT NOT_NULL DEFAULT 0',
	'option_key' => "VARCHAR(50) NULL",
	'option_value' => 'VARCHAR(255) NULL'
];
$db->CreateTable('pages_component_options', $table_params);
$db->CreateIndex('pages_component_options', 'idx_component_id', 'component_id');
DB_UPDATE_FILE
);


$migrations->Run('02_customcomponent_options2.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

// Renaming to avoid confusion between this and "pages_tile_option" which contains any variations from default
// values for all components (normal and custom).
$db->RenameTable('pages_component_options', 'pages_custom_component_fields');
DB_UPDATE_FILE
);


$migrations->Run('03_customcomponent_order.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

$db->AddColumn('pages_custom_component_fields', 'sort_order', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('04_customcomponent_table.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

$table_params = [
	'id' => "IDENTITY",
	'name' => "VARCHAR(50) NULL",
	'description' => "VARCHAR(255) NULL",
	'glyphicon' => "VARCHAR(20) NULL",
	'symname' => "VARCHAR(50) NULL",
	'size_constraints' => "VARCHAR(100) NULL",
	'js' => 'CLOB NULL',
	'css' => 'CLOB NULL',
	'html' => 'CLOB NULL'
];
$db->CreateTable('pages_component', $table_params);
DB_UPDATE_FILE
);


$migrations->Run('05_customcomponent_fields.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * @var Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

$db->DropColumn('pages_custom_component_fields', 'option_value');
$db->AlterColumn('pages_custom_component_fields', 'option_key', 'option_field');

$db->RenameTable('pages_component', 'pages_custom_component');
$db->RenameTable('pages_custom_component_fields', 'pages_custom_component_field');
DB_UPDATE_FILE
);


$migrations->Run('06_customcomponent_keys.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

$table_params = [
	'id' => 'IDENTITY',
	'field_id' => 'INT NOT_NULL DEFAULT 0',
	'option_key' => "VARCHAR(50) NULL",
	'option_value' => 'VARCHAR(255) NULL'
];
$db->CreateTable('pages_custom_component_key', $table_params);
$db->CreateIndex('pages_custom_component_key', 'idx_field_id', 'field_id');
DB_UPDATE_FILE
);


$migrations->Run('07_customcomponent_viewable.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * @var Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

$db->AddColumn('pages_custom_component', 'is_live', 'BOOL NOT_NULL DEFAULT 1' );
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('02.02');
