<?php
$_db_migration_to = '14.02'; // 3.0.3
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('20250925_page_trashcan_delete_index.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * BT-5539
 *
 * This migration removes indexes from the trashcan. Previously, items in the trashcan
 * were still appearing in global search results, which they should not.
 */

use Claromentis\Core\DAL;
use Claromentis\Pages\Search\Indexing\PageIndexing;
use Claromentis\Search\Indexing\IndexingQueue;

/** @var \Claromentis\Setup\SetupFacade $migrations */
$logger = $migrations->getLogger();

$logger->notice("Starting migration for BT-5539: Deleting search indexes of pages from the Pages trashcan");

$database = $migrations->GetDb();

try {
	$query = new DAL\Query('SELECT obj_id FROM pages_trash_can');
	$result = $database->query($query);

	while ($array = $result->fetchArray()) {
		IndexingQueue::DeleteIndex(PageIndexing::TYPE_NAME, $array['obj_id']);
	}
} catch (DAL\Exceptions\TransactionException $exception) {
	$logger->warning("Migration failed to delete indexes from the trashcan");
	$logger->debug($exception);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('14.02');
