define(["./PagesReadonly.class.js"], function (Pages) {

/**
 * Methods for components to interact with Pages
 *
 * The following events will be triggered on the main tile containing the "js-tile" CSS class and will also pass in the tile element.
 * To listen to them use something like -
 *
 * $('#current-component-identifier').closest('.js-tile').on('pages-tile-delete', function(event, element){do_some_code();});
 */

Pages.prototype._notifyTileAdded = function(element)
{
	element.trigger('pages-tile-add');
};

Pages.prototype._notifyTileMoved = function(element)
{
	element.trigger('pages-tile-move');
};

Pages.prototype._notifyTileDeleted = function(element)
{
	element.trigger('pages-tile-delete');
};

Pages.prototype._notifyTileResized = function(element)
{
	element.trigger('pages-tile-resize', element);
};

/**
 * The following events will be triggered on the page body.
 * To listen to them use something like -
 *
 * $(body).on('pages-started', function(event){do_some_code();});
 */
Pages.prototype._notifyPagesStarted = function()
{
	$('body').trigger('pages-started');
};

return Pages;
});