(function () {
	'use strict';

    var ng_module_name = 'delete_pageurl';

	angular.module(ng_module_name)
		.directive('deletePageurl', deletePageurl);

	deletePageurl.$inject = ['deletePageurlService', 'trashcanPreloadFactory'];
	function deletePageurl(deletePageurlService, trashcanPreloadFactory)
	{
		return {
			replace: false,
			restrict: 'E',
			controller: controller,
			controllerAs: 'deletePageurl',
			templateUrl: '/intranet/pages/html/includes/delete_pageurl_modal.directive.html'
		};

		function controller()
		{
			var ctrl = this;
			ctrl.data = {};

            ctrl.deletePageMessage = trashcanPreloadFactory.deletePageMessage;
            ctrl.deleteLinkMessage = trashcanPreloadFactory.deleteLinkMessage;
            ctrl.pageUrlReservedMessage = trashcanPreloadFactory.pageUrlReservedMessage;

			ctrl.show = function()
			{
				ctrl.data = deletePageurlService.data;
				angular.element('#deletePageurlModal').modal();
			};

			ctrl.submit = function()
			{
				deletePageurlService.submit();
				angular.element('#deletePageurlModal').modal('hide');
			};

			deletePageurlService.registerDisplayCallback(ctrl.show);
		}
	}
}());
