/**
 *
 * A service to coordinate the delete page/link modal between 2 directives.
 * It holds menu item data that is shared to both of them and allows them to notify each other.
 *
 */


(function () {
	'use strict';

    var ng_module_name = 'delete_pageurl';

	angular.module(ng_module_name)
		.service('deletePageurlService', deletePageurlService);

	function deletePageurlService()
	{
		var service = this;
		service.displayCallback = null;
		service.submitCallback = null;
		service.data = {};

		service.registerDisplayCallback = function(callback)
		{
			service.displayCallback = callback;
		};

		service.registerSubmitCallback = function(callback)
		{
			service.submitCallback = callback;
		};

		service.show = function()
		{
			if (service.displayCallback !== null)
				service.displayCallback();
		};

		service.submit = function()
		{
			if (service.submitCallback !== null)
				service.submitCallback(service.data);
		};

		service.setData = function(pageurl)
		{
			service.data = pageurl;
		};
	}
}());