(function () {
	'use strict';

	var ng_module_name = 'pagesOptionsBuilder';

	angular.module(ng_module_name)
		.directive('optionsBuilder', optionsBuilder);

	function optionsBuilder()
	{
		controller.$inject = ['$scope'];

		return {
			controller: controller,
			controllerAs: 'builder',
			replace: false,
			restrict: 'E',
			scope: {
				options: '=',
				types: '=',
				timeFormat: '@'
			},
			templateUrl: '/intranet/pages/html/includes/options_builder.html'
		};

		/** directive controller */
		function controller($scope)
		{
			var ctrl = this;

            this.$onInit = function() {
                ctrl.options = $scope.options;
                ctrl.types = $scope.types.types;
                ctrl.inputs = $scope.types.inputs;
                ctrl.timeFormat = $scope.timeFormat;
            };

			ctrl.editOption = {};
			ctrl.currentEdit = null;

			ctrl.optionsPlaceholder = "{\n  \"1\": \"Option A\",\n  \"2\": \"Option B\"\n}";

			ctrl.dragListeners =
			{
				clone: true
			};

			ctrl.placeholder = {
				label: lmsg('pages.custom.placeholder.label'),
				symname: lmsg('pages.custom.placeholder.symname')
			};

			ctrl.setEditOption = function (option)
			{
				ctrl.editOption = angular.copy(option);
				ctrl.currentEdit = option;
			};

			ctrl.deleteOption = function (option)
			{
				if (confirm('Are you sure?'))
				{
					var index = ctrl.options.indexOf(option);

					if (index > -1)
						ctrl.options.splice(index, 1);
				}
			};

			ctrl.addOption = function ()
			{
				var newOption = {
					title: '',
					type: 'string',
					input: 'string',
					symname: '',
					default:''
				};
				ctrl.options.push(newOption);
				ctrl.setEditOption(newOption);
				angular.element('#optionModal').modal('show');
			};

			ctrl.submitEdit = function ()
			{
				var options = {};
				var input = ctrl.editOption['input'];

				for (var option in ctrl.editOption)
				{
					var is_input = false;

					if (ctrl.inputs[input]) {
						is_input = ctrl.inputs[input].indexOf(option) > -1;
					}

					if (is_input || (option === 'symname') || (option === 'type')) {
						options[option] = ctrl.editOption[option];
					}
				}

				angular.copy(options, ctrl.currentEdit);
				ctrl.editOption = {};
				ctrl.currentEdit = null;
				angular.element('#optionModal').modal('hide');
			};

			ctrl.onTypeChange = function ()
			{
				// Reset the input to the first in the list
				ctrl.editOption.input = ctrl.types[ctrl.editOption.type].inputs[0].key;

				// Reset the default value
				ctrl.editOption.default = null;

				// Strip the title for dividers
				if (ctrl.editOption.type === 'divider') {
					delete ctrl.editOption.title;
				}
			};

			ctrl.isInputVisible = function (input)
			{
				if (typeof ctrl.inputs[ctrl.editOption.input] === 'undefined')
					return false;

				return ctrl.inputs[ctrl.editOption.input].indexOf(input) > -1;
			};

			ctrl.getDefaultType = function ()
			{
				if (['int', 'checkbox', 'textarea', 'date_picker', 'icon_picker', 'time_picker', 'datetime_picker', 'color_picker'].indexOf(ctrl.editOption.input) > -1)
					return ctrl.editOption.input;

				if (ctrl.editOption.input === 'none')
				{
					switch (ctrl.editOption.type)
					{
						case 'bool':
							return 'checkbox';
						case 'date':
							return 'date_picker';
					}
				}

				return 'text';
			};

            // ToDo: Remove these lines when a Claro >= 8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
		}
	}
}());
