(function () {
	'use strict';

    var ng_module_name = 'page_navigation';

	angular.module(ng_module_name)
		.directive('pageNavigationMenu', pageNavigationMenu);

	pageNavigationMenu.$inject = ['pageNavigationService'];
	function pageNavigationMenu(service)
	{
		return {
			replace: false,
			restrict: 'E',
			controller: controller,
			controllerAs: 'nav',
			templateUrl: '/intranet/pages/html/includes/page_navigation_menu.directive.html'
		};

		function controller()
		{
			var ctrl = this;

			ctrl.navData = service.getNavigationData();

			ctrl.getUrl = function(item)
			{
				return item.type === 'page' ? '/pages/' + item.full_url : item.link_url;
			};

			ctrl.getTarget = function(item)
			{
				return item.new_window ? '_window' : '';
			};

		}
	}
}());
