(function ()
{
	'use strict';

    var ng_module_name = 'tile_library';

	angular.module(ng_module_name)
		.controller('tileLibraryController', tile_library_controller);

	tile_library_controller.$inject = ['tileLibraryService'];
	function tile_library_controller(service)
	{
		var ctrl = this;

        ctrl.categories = service.GetCategories();
        ctrl.tiles = service.getTiles();
		ctrl.controlToken = {};

		// This will be updated by the tile-insert-location directive
		ctrl.insertLocation = {x: 0, y: 0};

		ctrl.onOpenPopover = function()
		{
			ctrl.controlToken.reset();

			cla.pages.insertLocation = ctrl.insertLocation;
		};
	}
}());
