(function () {
	'use strict';
    var ng_module_name = 'tile_settings';

	angular.module(ng_module_name)
		.directive('tileSettingsCustom', ['$compile', settingsCustom]);

	function settingsCustom($compile) {
		var directive = {
			controller: controller,
			controllerAs: 'ctrl',
			bindToController: true,
			replace: true,
			restrict: 'E',
			scope: {
				value: '=',
				option: '=',
				id: '@'
			}
		};

		return directive;
		//////////////////

		/** directive controller */
		function controller($scope, $element) {
			var ctrl = this;

            this.$onInit = function() {
                angular.element($element).html($compile(ctrl.value)($scope));
            };

            // ToDo: Remove these lines when a Claro >= 8.10 compatible branch of this module is available
            if (angular.version.major === 1 && angular.version.minor < 5) {
                this.$onInit();
            }
		}
	}
}());
