# Pages Change Log

## Unreleased

### New Features

- !99 UIUX-889 Added an option to customise the header colour for individual Pages components
  - Updated UI for Pages component options

## 3.0.1 - 13th August 2025

### Bug fixes

- !107 BT-5463 Fixed bug where documents version greater than 1 won't show in the embedded component

### Developer notes

- Merged upstream changes from 2.2.3

## 3.0.0 - 9th June 2025

### Bug fixes

- !104 BT-5346 Ensured the Safe Mode alert banner width respects individual page width settings

## 3.0.0-beta - 16th April 2025

- 1320b927 FRAM-1053 Fixed PHP 8 incompatibilities reported by PHPCS
- !87 PAGES-52 Added ability to add document previews in embed component
- Merged upstream changes from 2.2

## 3.0.0-alpha2 - 29th January 2025

### Developer notes

- Merged upstream changes from 2.2.0

## 3.0.0-alpha - 14th November 2024

### New features

- FRAM-954 Claromentis 10 compatibility
- !64 PAGES-13 Added Page Width setting, allowing 'Fixed', 'Full' and 'Theme default' options for individual pages
- !65 PAGES-42 Added safe mode page edit to allow recovery of components that may be misbehaving such as embedded JavaScript code or redirects

### Improvements

- !65 PAGES-42 Added safe mode page edit to allow recovery of components that may be misbehaving such as embedded JavaScript code or redirects 
- !75 AN-42 Updated styling for Announcements Broadcast Messages

## 2.2.3 - 8th August 2025

### Improvements

- !106 UIUX-920 Improved Pages spacing on small screen resolutions

## 2.2.2 - 3rd April 2025

### Improvements

- !97 BT-5223 Converted chevron arrow icon to ellipsis icon in pages list

## 2.2.1 - 7th March 2025

### Bug fix

- !95 BT-4930 Fixed special permissions icon alignment issue and converted menu item into a button in Pages list
- !96 BT-5177 Fixed image component with URL links missing border radius

## 2.2.0 - 28th January 2025

<!-- Minor release due to Core, IC Dashboard, and People component depending on these changes -->

### Improvements

- !91 UIUX-892 Updated standard Pages Grid styling with the larger card variation

### Bug fixes

- !94 BT-5104 Fixed image component missing border radius

## 2.1.16 - 10th January 2025

### Bug fixes

- !93 BT-5009 Fixed navbar toggler button overflow issue on mobile

### Developer notes

- !92 BT-5047 Fixed unresolved merge conflicts in in CSS file

## 2.1.15 - 12th November 2024

### Improvements

- !90 BT-4812 Added generic styling for card grid layout

## 2.1.14 - 18th October 2024

### Bug fixes

- !89 BT-4925 Fixed Pages Component delete settings width issue 

## 2.1.13 - 8th October 2024

- Merged upstream changes from v1.10

### Bug fixes

- !86 BT-4549 Fixed Pages component settings popover display issue on mobile

## 2.1.12 - 12th September 2024

### Bug fixes

- !85 FRAM-1007 BT-4865 Disco 046786 Updated the Image Component so that image uploads are stateless across requests. This change resolves the issue where uploaded images were not accessible from different servers in a distributed environment.

## 2.1.11 - 9th July 2024

- Merged upstream changes from 1.10

## 2.1.10 - 19th June 2024

### Improvements

- !80 PAGES-53 Centered and limited the width of content for Pages Site List, Pages Edit Site Properties, and Pages List when using full width themes

### Developer notes

- Merged upstream changes from v1.10

## 2.1.9 - 4th April 2024

- Merged upstream changes from 1.10

## 2.1.8 - 12th March 2024

- Merged upstream changes from 1.10

## 2.1.7 - 13th February 2024

### Bug fixes

- !78 PAGES-50 Fixed an issue where adding multiple Pages Components that use a custom input could break the component settings UI

## 2.1.6 - 6th February 2024

### Improvements

- !77 UIUX-862 Improved semantic heading titles in Pages breadcrumbs

## 2.1.5 - 20th December 2023

### Developer notes
- Merged upstream changes from 1.10.10

## 2.1.4 - 22nd November 2023

### Bug fixes

- !71 BT-4187 Disco 042507 Fixed height issue with an Embed component with a title when the iFrame option is used

## 2.1.3 - 18th October 2023

### Developer notes
- Merged upstream changes from 1.10.5 - 1.10.9

## 2.1.2 - 13th December 2022

### Improvements

- !62 BOOTY-582 Replaced utility classes usages with Bootstrap 4 standard utility classes
- !63 BOOTY-606 Updated pages default layout for new Claromentis installs
- FRAM-838 Added application menu item registration

### Bug fixes

- !61 BT-3466 Fixed page create/edit url address overflow issue
  - reorganised css/js assets in project
- 888b7fd4 BOOTY-577 Corrected issue with Pages resize handles, where size and design had changed after latest merge
- 31193b9a BT-3614 Fix for text overflow issue when adding component
- 218955f2 3ffb86a1 BT-3649 Fixed issue with Pages embed component where the corners weren't rounded properly
- 9c6849bc FRAM-838 Fixed initial homepage permissions for "All registered" users
- bf063ec8 BOOTY-613 Fixed issue where options in custom components can't be edited due to an error with the Claro 9 conversion
- 853e2122 BT-3613 Fixed issue with buttons wrapping on component delete popover when using larger fonts
- BT-3742 Fixed issue with spacing around custom pages 'Options' dialog when there aren't any options added

## 2.1.1 - 5th August 2022

### Improvement

- 4e1456bc BT-3485 Fixed minor design issue where outline appears when clicking on a page on site admin page
- 1587579a BT-3487 Fixed minor alignment issue with custom component options on smaller displays 
- BOOTY-500 Further updates to pages component IDs so they use the new class structure
  - 525797ba BOOTY-530 Image component
  - abf804f2 BOOTY-524 Embed component
  - b9491617 BOOTY-529 Greeting component
  - 5ea886be BOOTY-536 Text component
  - cb0690c6 BOOTY-539 Sites component
- !60 PAGES-11 Adds a unique class to each page that can be used by custom CSS.

## 2.1.0 - 22nd July 2022

### New Features
* !59 PAGES-20 Implemented "recently deleted" feature for sites, pages, and links

### Developer notes
* Site permission rights constants were tidied up. The single site manage permission is now bitmask 1 and named
  SITE_MANAGE instead of the confusing CREATOR_PERMS = 23. Sites also use three temporary rights during creation which
  have been renamed to make it obvious they are temporary and moved to bitmasks 32, 64 and 128 to stop them
  overlapping with any real ones now or in the future

## 2.0.2 - 22nd July 2022

### Improvements
- ff2799a3 BOOTY-500 Updated Blog, Policy and Discuss classes which are related to pages components
- a10c12d1 BOOTY-500 BOOTY-517 BOOTY-519 Updated Buttons and App Slider classes which are related to pages components

## 2.0.1 - 30th June 2022

### Bug fixes

- ac53d840 BOOTY-414 Minor fixes to pages components
  - BT-3443 Fixed issue with pages settings popovers not taking on the correct widths
  - BT-3444 Corrected error where text component background colour doesn't applying after v9 upgrade.
- Improved error and exception handling when rendering components

## 2.0.0 - 26th April 2022

### Bug fixes

- 034edb7f BOOTY-414 Consistency improvements in placeholder text in Pages Embed component as part of QA work
- 7003c303 BOOTY-414 Fixed bug with pages list items going missing when dragged
- 70ddcbb0 BOOTY-414 Number of small fixes and refinements to design and functionality of page structure functionality
- 70ddcbb0 83331eac BT-3289 Fixed edge case where form content can overflow the outer tile settings wrapper

## 2.0.0-beta - 25th February 2022
- Claromentis 9 compatibility
- BOOTY-469 changed page draft recovery button class

## 1.10.15 - 8th October 2024

### Bug fixes

- !84 BT-4850 Disco 046642 Resolved an issue where copying a site without copying its permissions caused the original site's subpages to lose their permissions

## 1.10.14 - 9th July 2024

- !83 BT-4773 Text component uploaded images are displayed using CDN URLs

## 1.10.13 - 12th June 2024

### Bug fixes

- !82 BT-1901 BT-4699 Add missing localisation in "Role Picker" and "Group Picker" option inputs.

## 1.10.12 - 4th April 2024

### Bug fixes

- !81 BT-4575 Disco 044755 Fixed an issue where adding a new page with disallowed characters in the URL fragment did not trigger an error

## 1.10.11 - 12th March 2024

- 380f4ce2 !78 PAGES-50 Backported from 2.1: Fixed an issue where adding multiple Pages Components that use a custom input could break the component settings UI

## 1.10.10 - 20th December 2023

### Bug fixes

- !69 BT-4294 Disco 43235 Fixed issue where an empty page title could cause a fatal error and render the site non-editable

## 1.10.9 - 18th October 2023

### Bug fixes

- !70 BT-4271 Disco 04292 Fixed tooltips sticking when 'search components' is used whilst adding components 

## 1.10.8 - 29th August 2023

- 49c761d8 Disco 041135 Disco 042877 Fixed the root cause of type errors when loading statistics for Pages Sites

## 1.10.7 - 29th August 2023

### Bug fixes

- 59589e1a Disco 041135 Fixed potential type error caused by Pages Site IDs in Statistics series data

## 1.10.6 - 14th August 2023

### Improvements

- !67 BT-4219 Disco 040396 Further improved the Pages Statistics chart query performance

## 1.10.5 - 14th June 2023

### Improvements

- !66 PAGES-45 Increased the maximum crop resolution for images uploaded to the Image component

## 1.10.4 - 10th February 2021
- !58 BT-3210 Disco 035934 Fixed rare and intermittent fatal errors when editing pages

## 1.10.3 - 10th November 2021
- f3d0a0c4 8d2b4bd3 BT-2783 Fixed Site/Pages list component warnings for Pages missing an associated Page URL
- d917acce BT-2782 Fixed image component failing to initialize when an image is yet to be provided
- !57 BT-3060 Disco 034668 Disco 034734 Improved Pages Statistics chart query performance

## 1.10.2 - 17th May 2021
### Bug fixes
- !53 BT-2393 Disco 32481 Fixed XHR-based select options not saving their value

## 1.10.1 - 14th May 2021
### Bug fixes
* !54 BT-2411 DISCO 32797 Fixed custom component javascript not being executed on page load

## 1.10.0 - 29th April 2021
### Bug fixes
* !52 BT-2366 Disco 032049 Fixed search indexing and querying for Page permissions

### Breaking changes
* !52 BT-2366 Disco 032049 Page URL Elasticsearch mapping updated: added `permissions` field
* Method signature changes:
  * `UseCase\UpdateChildrenPermissions::__construct()` updated to include dependencies needed for the
    changes below
  * `UseCase\UpdateChildrenPermissions::Update()` now accepts a page ID only, instead of forcing
    calling code to use `PagesRepository` to retrieve a tree of sub-pages
  * `Repository\PageRepository::GetAll()` return type hint added
    
### Developer notes
- Minimum Claromentis Core compatibility bumped from >=8.9 to ^8.10

## 1.9.9 - 23rd April 2021
### Bug fixes
* !51 BT-2348 Avoid sending homepage guests to an error page unless the homepage is actually set to a page with no public perms

## 1.9.8 - 16th February 2021
### Bug fixes
* !42 UIUX-721 Fixed issue with mobile menu showing on Pages due to inconsistencies with AngularJS

## 1.9.7 - 7th December 2020
### Improvements
* !48 BT-2109 Disco 030562, Disco 030430, Disco 029358 Improved Pages Statistics query performance

## 1.9.6 - 30th November 2020
### Bug fixes
* !49 BT-2074 Fixed radio buttons not displaying their values in pages tile options

## 1.9.5 - 20th November 2020
### Bug fixes
* !47 BT-2107 fixed warning `Specified key was too long; max key length is 1000 bytes Query` when creating database schema (index name: `pages_site_title`)

## 1.9.4 - 28th October 2020
* Merged forward `1.8.7`.

## 1.9.3 - 19th October 2020
* Merged forward `1.8.6`.

## 1.9.2 - 02nd October 2020
* Merged forward `1.8.5`.

## 1.9.1 - 24th August 2020
### Bug fixes
* !40 BT-1686 fixed incorrect number of unique views in pages statistic
* Merging in fixes from 1.8.4

## 1.8.7 - 28th October 2020
* Merged forward `1.7.6`.

### Developer notes
* !46 BT-2062 Updated failing Unit Tests.

## 1.8.6 - 19th October 2020
* !44 BT-2034 Fixed a page's URL not being updated when it was moved under a new parent

## 1.8.5 - 02nd October 2020
* Merged forward `1.7.5`.

## 1.8.4 - 24th August 2020
* !32 pages audit entries now link to the affected page/site

## 1.9.0 - 25th June 2020
* !38 DISCO 28379 Added database indexes to some database columns to improve the performance of Pages Statistics

## 1.8.3 - 16th June 2020
* FRAM-368 Made compatible with AngularJs 1.5+

## 1.7.6 - 28th October 2020
### Bug fixes
* !45 BT-2045 Page Component Tooltips will not linger when adding Pages Components to a Page.

## 1.7.5 - 02nd October 2020
* Merged forward `1.6.5`.

## 1.7.4 - 16th June 2020
* !37 CORE-1082 Updated default install sample page

## 1.8.2 - 31st March 2020
* Merging in fixes from 1.7.3

## 1.7.3 - 31st March 2020
* !33 BT-71 Added missing localisation to create site page
* !34 BT-80 Fixed issue where new page url input box is hidden if root url is too long
* Merging in fixes from 1.6.4

## 1.6.5 - 02nd October 2020
* Merged forward `1.5.7`.

## 1.6.4 - 31st March 2020
* Merging in fixes from 1.5.7

## 1.5.7 - 19th March 2020
### Bug fixes
* !31 BT-886 Sites can no longer be created with an empty name
* !35 BT-476 Pages will now attempt to create its user uploads directory before failing with a "directory not found" error

## 1.7.2 - 27th November 2019
* CORE-1036 Added Hungarian translation

## 1.8.1 - 31st October 2019
* Merged forward bugfixes from 1.7.1

## 1.8.0 - 29th October 2019
### Features
* Added Uzbek translation
* (CORE-801) Added suuport for Statistics plugin and implemented stats for page views and unique views.

## 1.7.1
* !28 CORE-995 Renamed cla-popover element to avoid name collision with Core's new Design System components.
* Merged forward bugfixes from 1.6.3

## 1.7.0

### Features
* !26 CORE-951 Added Categories to the Pages Component browser UI.
* !26 CORE-951 Version 2 of the Pages REST API is now available at: `/api/pages/v2`.
* !26 CORE-951 Added the Categories API endpoint: `/categories`.

### Improvements
* !26 CORE-973 Added Component Categories:
    * Calendar, Occasions & Events
    * Documents & Policies
* !26 CORE-973 Added all Custom Components to the Category `Embed & Custom`.
* !26 CORE-973 Added Component `Embed` to Categories `Embed & Custom` and `Photos, Videos & Text`.
* !26 CORE-973 Added Component `Greeting` to Categories `People, Communication & Social` and `Photos, Videos & Text`.
* !26 CORE-973 Added Component `Image` to Category `Photos, Videos & Text`.
* !26 CORE-973 Added Component `Sites/Pages list` to Category `Productivity & Shortcuts`.
* !26 CORE-973 Added Component `Text` to Category `Productivity & Shortcuts`.
* !26 CORE-974 Added Localized Titles to the following Components:
    * All Custom Components
    * Embed
    * Image
    * Sites/Pages list
    * Text

## 1.6.3
* Merged forward bugfixes from 1.5.6

## 1.6.2
* UIUX-542 Fixed bug with spacing around Navbar dropdown items when displaying on Pages webpages
* Merged forward bugfixes from 1.5

## 1.6.1
* Fixes for custom options
* Merged Russian translations from 1.5 branch

## 1.6.0
* Pages can now have 6 columns as well as the default 4 !16
* Permissions can now set per-page instead of per-site !19
* Added ability within Pages Layout to show or hide page frame !20
* Profile image in Greetings Component is now correctly centered !21
* Nav items with a "#" in them caused a JS error when clicking anywhere on the page. (#571, CORE-191)
* Small design change to display design of labels and dots for label
* Fix bug where wrong class is added to component (CORE-353)
* Deleting tile, shortening 'No, keep this tile' to 'No keep it' so it doesn't drop easily to second line UIUX-347
* Site contents page could fail to display anything due to timing. (CORE-397)
* Changed greeting image layout to vertically align with greeting text. (UIUX-393)
* Merging in fixes from 1.5.3

## 1.5.8 - 02nd October 2020
### Bug fixes
* !43 UIUX-726 Page Component Tooltips will not linger when adding Pages Components to a Page.

## 1.5.6
* BT-871 (Disco 025907) Fixed Sites and Pages saving in an invalid state if a URL path containing a slash (/) was given

## 1.5.5
* Fixed bug that was preventing the admin button not working (BT-498)

## 1.5.4
* Added Russian translations and twig templates

## 1.5.3
* Merging in fixes from 1.4.3

## 1.5.2
* Migration to reverse some table columns that may have had a boolean default of 0 stored instead of 1
* Trying to fix the error when adding the first buttons component to the page and no button picker showing. (CORE-318)
* Bugfix: "Create site" button was replaced with an error if a site had no URL somehow. (CORE-324)

## 1.5.1
* Merging in fixes from 1.4.2

## 1.4.3
* Merged forward fixes from 1.3.8
* Migration to reverse some table columns that may have had a boolean default of 0 stored instead of 1

## 1.4.2
* Fixed compatibility bug with MSSQL
* Fixed badly generated schema due to commit 3a7ac056

## 1.5.0
* Nav items with a "#" in them caused a JS error when clicking anywhere on the page. (#571, CORE-191)
* Fixed compatibility bug with MSSQL when installing.
* Compatible with Claromentis 8.6
* Added new component options for Buttons, collapsible sections, fancy radio buttons, custom input controls and icon grids
* Added ability for data to be saved per-user.
* Added "created by" and "modified by" data.
* Given code embed transparent background and added 'Allow scroll' option.
* Corrected transparent background issue (UIUX-8)
* Added option persistence setting to allow fields that don't get saved.
* Fixed localisation for Sites Title (Jira UIUX-145)
* Bugfix: guest users caused an error. (comp/cla-weather-2#48)
* Adding item-shadow css class so that video and embed can have slight shadow if it is defined in design panel

## 1.4.1
* Fix for Image Component links not having hover effect in Chrome & Safari
* Enabling Localisation for Pages App Name in Admin Panel and Application Menu
* Added validation to date/time picker, colour picker and string input to improve UX.
* Added missing localisation string for maxlength string input validation (Countdown #15)
* Added improved max length error message for string input (Countdown #16)

## 1.4.0
* Compatible with Claromentis 8.5
* Added colour, date and datetime settings types
* Increased height of the settings popover

## 1.3.8
* Page and site property title fields were set to allow a maximum of 50 characters. (Disco #22632, CORE-305)
* Support for pages sites with long titles / URLs has been added.
* Adjusted pages modal form fields width (UIUX-275)

## 1.3.7
* Site content page sometimes did not show any pages. (Disco 22262)

## 1.3.6
* Fix from 1.2.8

## 1.2.8
* Site links containing # caused JS error when then page was clicked anywhere. (#553, Disco 21463)

## 1.3.5
* Updated EQCSS and disabled it running on mouse click/move due to performance issues.

## 1.3.4
* Updated Sites List component layout and added icons to the Pages List (#530 & #532)
* Fixed bug which stops profile link being clicked on greeting and removed settings button if no settings are available

## 1.3.3
* Composer.json compatibility with future versions of core.

## 1.3.2
* Pages will now set the homepage to be the new "Main" pages site when it is
 installed.
* The automatically generated "Main" site now has no subpages, and the site
 homepage has a brand new layout that uses all the space on the page.  
* Added a new component that can show a list of sites, or a list of pages in
 a site.
* Many small bugfixes

## 1.3.1
* Resolved: Error when creating new site. (#504)

## 1.3.0
* Compatibility with Claromentis 8.3

## 1.2.7
* Copying a site using another as a template failed when the original site had links as well as pages. (Disco 20176)

## 1.2.6
* Proper release for the fixes included in 1.2.4 and 1.2.5

## 1.2.4 and 1.2.5
####Incomplete releases so were not installable
* Improving UX when using Pages in Site card by exposing edit icon when user has edit right and removing hover edit
* Replacing link on view page from view site info to edit page properties as expected by user
* Updating localisation and Icons to edit page and site properties.
* Breaking JS in the embed component stopped Pages UI code from running. (#516)
* Fix for embed component to convert <script> source tags into require calls. (#516)

## 1.2.3
* Added German translation for all phrases

## 1.2.2
* Made compatible with Claromentis 8.3 (keeping compatibility with 8.2 too)
* Added many configuration options to image component
* Minor visual improvements
* Fixed audit recording page view under wrong category

## 1.2.1
* Bugfix for broken add/edit custom components page (#474)

## 1.2.0
* Added ability to export and import custom components
* Sites and pages can be created by copying existing rather than starting from blank
* Added "Greeting" component
* Added some missing localisation

## 1.1.0
* Sites can now have a cover image
* Minor bugfixes

## 1.1.0-rc
* All major bugs fixed
* A large number of minor bugs fixed
* Stabilized module for RC release

## 1.1.0-beta3
* Visual fixes
* Added some missing localisation

## 1.1.0-beta2
* Added custom javascript components
* Added indexing content for HTML component
* Tidied up UI

## 1.1.0-beta
* Added multiple sites with permissions and nested pages
* Support for Claromentis 8.2 themes
* HTML, Image, Embed, Video components

## 1.0.2
* Minor bugfix for IE10/11 compatibility when adding tiles
* Minor text fix

## 1.0.1
* Fixed error making it impossible to delete the last tile on a page
* Removed forced z-index position of a user picker, causing it sometimes not shown properly

## 1.0.0
* Improved errors handling while editing a page

## 1.0.0-rc
* Large number of bugfixes and optimisations

## 0.0.3
* A lot of cleanup and bugfixing
* Ability to add and delete components
* Stabilised components API
* Simplified drafts to not have multiple versions
* Page locking to prevent concurrent editing

## 0.0.2
* Added options for components
* Implemented drafts
* Corrected visual side of components
* Added ACL

## 0.0.1
* First prototype
