<?php
$_db_migration_to = '07.01'; // 1.6.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_add_inherited.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('pages_page', 'inherited', 'BOOL NOT_NULL DEFAULT 1');


DB_UPDATE_FILE
);


$migrations->Run('03_add_pages_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('pages_page', 'column_count', 'INT NOT_NULL DEFAULT 4');
DB_UPDATE_FILE
);


$migrations->Run('04_add_page_wrap.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AddColumn('pages_page', 'bg_wrap', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('05_migrate_permissions.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->DisableTokenCheck();

$result = $db->query("select s.id
from pages_site s
       left join permissions p on p.object_id = s.id
where p.class_id = int:int_id", 132);

$site_ids = [];
while ($row = $result->fetchRow())
{
	$site_ids[] = $row[0];
}
$site_ids = array_unique($site_ids);

foreach ($site_ids as $site_id)
{
	$pages = GetPagesForSite($site_id, $db);
	$home_page_id = GetHomepageId($pages);
	if (HomepageHasPermissions($home_page_id, $db))
		continue;

	//set homepage not inherited 
	$db->query("UPDATE pages_page SET inherited=int:inherited WHERE id=int:id", 0, $home_page_id);

	$site_perms = GetSitePermissions($site_id, $db);
	DeleteSitePermissions($site_id, $db);
	foreach ($site_perms as $perm)
	{
		if ($perm['rights'] == 23)
		{
			$db->query("INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES (int:class_id, int:object_id, int:perm_class_id, int:owner_id, int:rights)", 132, $site_id, $perm['perm_owner_class_id'], $perm['perm_owner_id'], 1);
			continue;
		}

		foreach ($pages as $page)
		{
			if ($perm['rights'] == 1)
			{
				$db->query("INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES (int:class_id, int:object_id, int:perm_class_id, int:owner_id, int:rights)", 144, $page['id'], $perm['perm_owner_class_id'], $perm['perm_owner_id'], 1);
			}

			if ($perm['rights'] == 7)
			{
				$db->query("INSERT INTO permissions (class_id, object_id, perm_owner_class_id, perm_owner_id, rights) VALUES (int:class_id, int:object_id, int:perm_class_id, int:owner_id, int:rights)", 144, $page['id'], $perm['perm_owner_class_id'], $perm['perm_owner_id'], 3);
			}
		}
	}

}


function GetPagesForSite($site_id, $db)
{

	/** @var \Claromentis\Core\DAL\Db $db */
	$result = $db->query("SELECT mi.parent_id, p.*
FROM pages_page p
       LEFT JOIN pages_url u ON p.id = u.active_page_id
       LEFT JOIN pages_menu_item mi ON mi.url_id = u.id
WHERE mi.site_id = int:site_id", $site_id);

	$pages = [];

	while ($row = $result->fetchArray())
		$pages[] = $row;

	return $pages;
}

function GetHomepageId($pages)
{
	foreach ($pages as $page)
	{
		if ($page['parent_id'] == 0)
			return $page['id'];
	}
}

function HomepageHasPermissions($id, $db)
{
	/** @var \Claromentis\Core\DAL\Db $db */
	$result = $db->query("SELECT * FROM permissions p WHERE p.object_id = int:object_id AND p.class_id = int:class_id", $id, 144);

	if ($result->hasData())
		return true;

	return false;
}

function GetSitePermissions($site_id, $db)
{
	/** @var \Claromentis\Core\DAL\Db $db */
	$result = $db->query("SELECT p.*
FROM permissions p
WHERE p.object_id = int:object_id and p.class_id = int:class_id", $site_id, 132);

	$site_perms = [];
	while ($row = $result->fetchArray())
	{
		$site_perms[] = $row;
	}
	return $site_perms;
}

function DeleteSitePermissions($site_id, $db)
{
	/** @var \Claromentis\Core\DAL\Db $db */
	$db->query("DELETE FROM permissions WHERE object_id = int:object_id and class_id = int:class_id", $site_id, 132);
}




DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('07.01');
