define([], function () {

var Pages = function()
{
};

Pages.prototype.grid = null;
Pages.prototype.verticalMargin = 20;
Pages.prototype.horizontalMargin = 20;
Pages.prototype.columnCount = 4;

Pages.prototype.initGridStack = function()
{
	var dragClass = 'ui-draggable-handle';

	// Use just the tile header for dragging if on a touchscreen device
	if (($('html').hasClass('touch-enabled')) &&
		(/Android|iPad/i.test(navigator.userAgent)))
	{
		dragClass += '-touchscreen';
	}
	var min_width = 768;
	if (this.columnCount === 6)
	{
		min_width = 980;
	}

	var options = {
		width: this.columnCount,
		cellHeight: 47,
		verticalMargin: this.verticalMargin,
		animate: true,
		handleClass: dragClass,
		disableDrag: true,
		disableResize: true,
        placeholderClass: 'grid-stack-placeholder grid-stack-item-' + this.columnCount,
		minWidth: min_width
	};

	var grid = $('.grid-stack');
	grid.css('display', 'none');
	grid.gridstack(options);
	grid.css('display', 'block');
	this.grid = grid.data('gridstack');

	// add pages class to grid-stack screen
	$( 'body:has(.grid-stack)' ).addClass( 'pages-index' );

	// add style class to empty components
	$( '.panel:has(.empty-component-alert)' ).addClass( 'empty-component' );
};

	Pages.prototype.init = function(columns)
	{
		this.grid = null;
		this.columnCount = columns;

		this.initGridStack();

		$('.pages-startup')
			.css('opacity', '1')
			.css('transition', 'moz-opacity 0.5s ease-in-out')
			.css('transition', 'webkit-opacity 0.5s ease-in-out')
			.css('transition', 'opacity 0.5s ease-in-out');

		this._notifyPagesStarted();

		$('.js-tile').trigger('pages-tile-add'); // notify all preloaded tiles that they have been loaded
	};

Pages.prototype.populateTile = function(tile_id, header, body) {
    var base = $('.js-tile[data-tile_id="' + tile_id + '"]');
    $('.js-tile-body-container', base).css('opacity', '0');
    var $header = $('.js-tile-header', base);
    if (header !== null && header !== '') {
        $header.html(header).show();
        $header.removeClass('hide-header');
    } else {
        $header.hide();
        $header.addClass('hide-header');
    }
    $('.js-tile-body-container', base).html(body);
    window.setTimeout(function(){
        $('.js-tile-body-container', base).css('opacity', '1');
    },100);

    this._notifyTileAdded(base);
    return base;
};

return Pages;
});
