define(['jquery'], function ($) {
	return function () {
		listActions();
	}

	function listActions() {
		$('#component_list').on('click', '.js-dt-edit', function () {
			var id = $(this).data('id');
			window.location.href = "/pages/admin/components/"+id;
		});

		$('#component_list').on('click', '.js-dt-delete', function () {
			var id = $(this).data('id');
			if(window.confirm(lmsg('pages.admin.custom_delete_confirm'))) {
				$.ajax({
					url: '/api/pages/v0/admin/custom/' + id + '/delete',
					type: 'DELETE',
					success: function (d) {
						$('#component_list table').DataTable().draw();
					}
				});
			}
			return false;
		});

		$('#component_list').on('click', '.js-dt-view', function () {
			var id = $(this).data('id');
			var $glyph_dom = $(this).find('ion-icon');
			var $glyph_link = $(this);

			$.ajax({
				url: '/api/pages/v0/admin/custom/'+id+'/setviewable',
				type: 'post',
				success: function (d) {
					if (d.viewable == 1) {
						$glyph_dom.removeAttr('name').attr('name','eye-outline');
						$glyph_link.attr({"data-original-title": lmsg('pages.admin.custom_viewable')});
					}
					else {
                        $glyph_dom.removeAttr('name').attr('name','eye-off-outline');
                        $glyph_link.attr({"data-original-title": lmsg('pages.admin.custom_hidden')});
					}
				}
			});

			return false;
		});
	}
});
