(function () {
	'use strict';

    var ng_module_name = 'page_navigation';

	angular.module(ng_module_name)
		.directive('pageNavigationLoader', pageNavigationLoader);

	pageNavigationLoader.$inject = ['pageNavigationService', 'breadcrumb.service'];
	function pageNavigationLoader(navService, breadcrumbService)
	{
		return {
			replace: false,
			restrict: 'E',
			controller: controller,
			controllerAs: 'loader'
		};

		function controller()
		{
			var ctrl = this;

			ctrl.init = function(navigationData)
			{
				navService.setNavigationData(navigationData);
				breadcrumbService.setCrumbs(navigationData.breadcrumbs);
			};
		}
	}
}());