define([], function (){
var Tile = function()
{
};

Tile.prototype.id = 0;
Tile.prototype.type = '';
Tile.prototype.layout_id = 0;

Tile.prototype.x = -1;
Tile.prototype.y = -1;
Tile.prototype.width = -1;
Tile.prototype.height = -1;

Tile.prototype.options = [];

Tile.prototype.mutationRequest = null;

Tile.prototype.mutateOnChange = function()
{
	var self = this;
	if (this.mutationRequest !== null)
	{
		var request = this.mutationRequest;
		this.mutationRequest = null;
		request.onreadystatechange = null;
		request.abort();
	}

	this.mutationRequest = $.ajax(
		{
			url: '/api/pages/' + cla.pages.layout_id + '/tiles/' + this.id + '/refresh_options',
			method: 'PUT',
			contentType: 'application/json',
			data: JSON.stringify({
				options: this.options
			}),
			dataType: 'json',
			success: function(data)
			{
				self.mutationRequest = null;

				if (!data.status.success)
				{
					cla.showMessage(data.status.message, '', true);
					return;
				}

				Object.keys(data.options).forEach(function (option)
				{
					// Convert int values to string if select2 is going to be used
					Object.keys(data.options[option]).forEach(function (field)
					{
						if ((field === 'value') &&
							(data.options[option]['input'] === 'select' ||
								data.options[option]['input'] === 'radio') &&
							(data.options[option][field] === parseInt(data.options[option][field])))
						{
							data.options[option][field] = '' + parseInt(data.options[option][field]);
						}
					});
					// Propagate any widget tokens (for resetting pickers, etc)
					if ((typeof self.options[option] === 'object') &&
						(typeof self.options[option]['token'] === 'object'))
					{
						data.options[option]['token'] = self.options[option]['token'];
					}

					// Rename 'boolean' to 'bool' to keep the frontend code clean
					if ((typeof data.options[option] === 'object') &&
						(typeof data.options[option]['input'] === 'string') &&
						(data.options[option]['input'] === 'boolean'))
					{
						data.options[option]['input'] = 'bool';
					}
				});

				// Propagate entire fields that may have been hidden by removing them
				// instead of setting input = none
				Object.keys(self.options).forEach(function (option)
				{
					if ((typeof data.options[option] === 'undefined') &&
						(typeof self.options[option] !== 'undefined'))
					{
						data.options[option] = self.options[option];
						data.options[option]['input'] = 'none';
					}
				});

				self.options = data.options;

				var scope = angular.element('.grid-stack-item[data-tile_id=' + self.id + '] .js-settings_app_directive div').scope();
				if (typeof scope === 'object')
				{
					scope.$apply();
					scope.select2ify();
				}
			},
			error: function (data) {
				if (self.mutationRequest === null)
					return;

				if (typeof data.responseJSON.error === 'undefined')
					cla.showMessage(data.responseText, '', true);

				cla.showMessage(data.responseJSON.message, '', true);
			}
		});
};

return Tile;
});
