<?php
namespace Claromentis\Pages\UseCase;

$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"] ?: array()) + array("_e167da36" . "0aa15da9e" . "efff03074" . "9f85ef" => base64_decode("VGhlIHVwZGF0ZWQ" . "gcGFnZSBjb250ZW" . "50IGlzIHB1Ymxpc" . "2hlZA=="), "_f6ab5a0501" . "96eebba1afb" . "107ad0143d0" => base64_decode("Y2hlY" . "2tvdX" . "Q="), "_3f05c7e033d5fa58" . "83b27e9248e3ab53" => base64_decode("cG" . "Fn" . "ZX" . "M="), "_8142def44b242bc756c812f4ab9" . "6a3ea" => base64_decode("VGhlIHBhZ2UgaXMgbm90IGNoZWNrZWQgb3V0IC0gb" . "m90aGluZyB0byBwdWJsaXNo"), "_d1de6d14d3d23752c1f5" . "1753f403b72e" => base64_decode("Y2hlY2tpbg=" . "="), "_017e0023480ae2b406f84af6c66f" . "5110" => base64_decode("UGFnZSBjaGVja2VkI" . "G91dA=="), "_f7e58afec" . "3ec8739e03" . "ac554a75d1" . "ffa" => base64_decode("UGFnZSBlZGl0aW5nIGNhbm" . "NlbGxlZA=="));
use Claromentis\Core\Audit\Audit;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Pages\Exception\AccessDeniedException;
use Claromentis\Pages\Exception\InvalidObjectStateException;
use Claromentis\Pages\Exception\WorkingCopyExistsException;
use Claromentis\Pages\Facade\Drafts;
use Claromentis\Pages\Lock\LockService;
use Claromentis\Pages\Model\Page;
use Claromentis\Pages\Model\PageUrl;
use Claromentis\Pages\PagesAcl;
use Claromentis\Pages\Search\Indexing\PageIndexing;
use Claromentis\Search\Indexing\IndexingQueue;




class CheckoutPublish
{
    protected $drafts;
    protected $acl;
    protected $locks;
    protected Audit $audit;
    public function __construct(Drafts $_ca650641449d5d94bb77fc46da77ed8a, PagesAcl $acl, LockService $_9cd4b2152729fd679e63852ebc623594, Audit $audit)
    {
        $this->drafts = $_ca650641449d5d94bb77fc46da77ed8a;
        $this->acl = $acl;
        $this->locks = $_9cd4b2152729fd679e63852ebc623594;
        $this->audit = $audit;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Publish(SecurityContext $security, PageUrl $page_url)
    {
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if (!$this->acl->CanEditPage($security, $_8c02736ffb2efc1d69d2c9a2a34e7294)) {
            throw new AccessDeniedException();
        }
        
        
        $this->locks->Lock($page_url->id, $security->GetUserId());
        if (!$_8c02736ffb2efc1d69d2c9a2a34e7294) {
            throw new InvalidObjectStateException($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_8142def44" . "b242bc756c" . "812f4ab96a" . "3ea"]);
        }
        $this->drafts->Publish($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294, $security);
        $this->locks->Release($page_url->id, $security->GetUserId());
        $this->audit->Success($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_3f05c7e033d5fa5883" . "b27e9248e3ab53"], $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_d1de6d14d3d23752c1f5175" . "3f403b72e"], $page_url->id, $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_e167da360aa15da9eefff" . "030749f85ef"]);
        IndexingQueue::Reindex(PageIndexing::TYPE_NAME, $page_url->id);
    }
    
    
    
    
    
    
    
    
    
    
    public function GetWorkingCopy(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        return $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Checkout(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $this->locks->Lock($page_url->id, $security->GetUserId());
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            throw new WorkingCopyExistsException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->CreateWorkingCopy($page_url, $security->GetUserId());
        $this->drafts->DeleteWorkingCopiesExcept($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        $this->audit->Success($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_3f05c7e033d5fa5883b27e" . "9248e3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_f6ab5a050196eebba1afb107" . "ad0143d0"], $page_url->id, $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_017e002" . "3480ae2b" . "406f84af" . "6c66f511" . "0"]);
        return $_8c02736ffb2efc1d69d2c9a2a34e7294;
    }
    
    
    
    
    
    
    
    
    public function CancelEditing(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            $this->drafts->DeleteWorkingCopy($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        }
        $this->audit->Failure($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_3f05c7e033d5fa5883b27e9248e" . "3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_f6ab5a05019" . "6eebba1afb10" . "7ad0143d0"], $page_url->id, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_f7e58afec3ec8739e03ac55" . "4a75d1ffa"]);
        $this->locks->Release($page_url->id, $security->GetUserId());
    }
}