<?php
$_db_migration_to = '14.01'; // 3.0.0-alpha
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01-add-theme-width.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

# PAGES-13 added column page_layout_width
$db->AddColumn('pages_page', 'page_layout_width', 'INT DEFAULT 0');

DB_UPDATE_FILE
);


$migrations->Run('02-update-column-name.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

# PAGES-13 rename column
$db->AlterColumn('pages_page', 'page_layout_width', 'width');

DB_UPDATE_FILE
);


$migrations->Run('03-delete-and-create-width-column.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

# PAGES-13 set NOT_NULL to fix an issue on MSSQL server
$db->AlterColumn('pages_page', 'width', 'width', 'INT NOT_NULL DEFAULT 0');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('14.01');
