<?php
// This file contains the database schema version 14.02
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// pages_custom_component
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(50) NULL",
	'description'	=>	"VARCHAR(255) NULL",
	'glyphicon'	=>	"VARCHAR(20) NULL",
	'symname'	=>	"VARCHAR(50) NULL",
	'size_constraints'	=>	"VARCHAR(100) NULL",
	'js'	=>	"CLOB NULL",
	'css'	=>	"CLOB NULL",
	'html'	=>	"CLOB NULL",
	'is_live'	=>	"BOOL NOT_NULL DEFAULT 1",
);

$db->CreateTable('pages_custom_component', $table_descr, true);



// pages_custom_component_field
$table_descr = array(
	'id'	=>	"IDENTITY",
	'component_id'	=>	"INT NOT_NULL DEFAULT 0",
	'option_field'	=>	"VARCHAR(50) NULL",
	'sort_order'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('pages_custom_component_field', $table_descr, true);
$db->CreateIndex('pages_custom_component_field', 'idx_component_id', 'component_id');



// pages_custom_component_key
$table_descr = array(
	'id'	=>	"IDENTITY",
	'field_id'	=>	"INT NOT_NULL DEFAULT 0",
	'option_key'	=>	"VARCHAR(50) NULL",
	'option_value'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('pages_custom_component_key', $table_descr, true);
$db->CreateIndex('pages_custom_component_key', 'idx_field_id', 'field_id');



// pages_lock
$table_descr = array(
	'url_id'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'exp_date'	=>	"INT_DATE NULL",
);

$db->CreateTable('pages_lock', $table_descr, true);
$db->CreateIndex('pages_lock', 'pages_lock_exp_date', 'exp_date');



// pages_menu_item
$table_descr = array(
	'id'	=>	"IDENTITY",
	'site_id'	=>	"INT NOT_NULL",
	'parent_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(256) NULL",
	'type'	=>	"INT NOT_NULL",
	'link_url'	=>	"VARCHAR(1024) NULL",
	'url_id'	=>	"INT NULL",
	'new_window'	=>	"BOOL NOT_NULL DEFAULT 0",
	'is_visible'	=>	"BOOL NOT_NULL DEFAULT 1",
	'display_order'	=>	"INT NOT_NULL",
	'is_deleted'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('pages_menu_item', $table_descr, true);
$db->CreateIndex('pages_menu_item', 'pages_menu_item_url_id', 'url_id');
$db->CreateIndex('pages_menu_item', 'pages_menu_item_site_id', 'site_id');
$db->CreateIndex('pages_menu_item', 'pages_menu_item_parent_id', 'parent_id');



// pages_page
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(1024) NULL",
	'version'	=>	"INT NOT_NULL DEFAULT 1",
	'is_draft'	=>	"BOOL NOT_NULL DEFAULT 0",
	'url_id'	=>	"INT NULL",
	'editor_id'	=>	"INT NULL DEFAULT NULL",
	'show_title'	=>	"BOOL NULL DEFAULT 0",
	'show_menu'	=>	"BOOL NULL DEFAULT 0",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'created_by_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'modified_by'	=>	"INT NULL DEFAULT 0",
	'modified_by_date'	=>	"INT_DATE NULL DEFAULT 0",
	'inherited'	=>	"BOOL NOT_NULL DEFAULT 1",
	'column_count'	=>	"INT NOT_NULL DEFAULT 4",
	'bg_wrap'	=>	"INT NOT_NULL DEFAULT 0",
	'width'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('pages_page', $table_descr, true);



// pages_site
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(256) NULL",
	'url_id'	=>	"INT NULL",
	'created_by'	=>	"INT NOT_NULL DEFAULT 0",
	'created_by_date'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'modified_by'	=>	"INT NULL DEFAULT 0",
	'modified_by_date'	=>	"INT_DATE NULL DEFAULT 0",
	'is_deleted'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('pages_site', $table_descr, true);
$db->CreateIndex('pages_site', 'pages_site_url_id', 'url_id');
$db->CreateIndex('pages_site', 'pages_site_title', 'title(100)');



// pages_tile
$table_descr = array(
	'id'	=>	"IDENTITY",
	'page_id'	=>	"INT NOT_NULL",
	'class_key'	=>	"VARCHAR(255) NULL",
	'x'	=>	"INT NOT_NULL",
	'y'	=>	"INT NOT_NULL",
	'width'	=>	"INT NOT_NULL",
	'height'	=>	"INT NOT_NULL",
	'deleted'	=>	"BOOL NOT_NULL DEFAULT 0",
);

$db->CreateTable('pages_tile', $table_descr, true);



// pages_tile_option
$table_descr = array(
	'id'	=>	"IDENTITY",
	'tile_id'	=>	"INT NOT_NULL",
	'name'	=>	"VARCHAR(255) NULL",
	'value'	=>	"VARCHAR_MAX NULL",
);

$db->CreateTable('pages_tile_option', $table_descr, true);



// pages_trash_can
$table_descr = array(
	'id'	=>	"IDENTITY",
	'obj_id'	=>	"INT NULL",
	'aggregation'	=>	"INT NOT_NULL",
	'user_id'	=>	"INT NOT_NULL",
	'deletion_date'	=>	"INT NOT_NULL",
	'title'	=>	"VARCHAR(255) NULL",
	'orig_location'	=>	"VARCHAR(255) NULL",
	'description'	=>	"VARCHAR_MAX NULL",
	'site_id'	=>	"INT NOT_NULL",
	'type'	=>	"INT NOT_NULL",
);

$db->CreateTable('pages_trash_can', $table_descr, true);



// pages_unsafe_string
$table_descr = array(
	'id'	=>	"IDENTITY",
	'secret'	=>	"VARCHAR(128) NULL",
	'content'	=>	"CLOB NULL",
);

$db->CreateTable('pages_unsafe_string', $table_descr, true);



// pages_url
$table_descr = array(
	'id'	=>	"IDENTITY",
	'full_url'	=>	"VARCHAR(1024) NULL",
	'active_page_id'	=>	"INT NULL",
	'latest_page_id'	=>	"INT NULL",
	'site_id'	=>	"INT NULL",
);

$db->CreateTable('pages_url', $table_descr, true);
$db->CreateIndex('pages_url', 'pages_url_site_id', 'site_id');



// pages_user_option
$table_descr = array(
	'tile_id'	=>	"INT NOT_NULL DEFAULT 0",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'field_type'	=>	"VARCHAR(100) NULL",
	'value'	=>	"VARCHAR(255) NOT_NULL DEFAULT ' '",
);

$db->CreateTable('pages_user_option', $table_descr, true);





//===========================================================================================
$migrations->SetVersion('14.02');
