<?php
namespace Claromentis\Pages\UseCase;

$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] ?: array()) + array("_d1de6d14" . "d3d23752c" . "1f51753f4" . "03b72e" => base64_decode("Y2hl" . "Y2tp" . "bg=="), "_3f05c7e033d5fa5883b27e9248e3a" . "b53" => base64_decode("cGF" . "nZX" . "M="), "_e167da360aa15da9eefff030749" . "f85ef" => base64_decode("VGhlIHVwZGF0ZWQgcGFnZSBjb" . "250ZW50IGlzIHB1Ymxpc2hlZA" . "=="), "_f6ab5a050196eebba1afb107ad0143d" . "0" => base64_decode("Y2hlY2tv" . "dXQ="), "_017e0023480ae2b40" . "6f84af6c66f5110" => base64_decode("UGFnZSBjaGVja" . "2VkIG91dA=="), "_f7e58afec" . "3ec8739e03" . "ac554a75d1" . "ffa" => base64_decode("UGFnZSBlZGl0aW5nIGNh" . "bmNlbGxlZA=="), "_8142def44b242bc756c812f4ab96a3" . "ea" => base64_decode("VGhlIHBhZ2UgaXMgbm90IGNoZ" . "WNrZWQgb3V0IC0gbm90aGluZy" . "B0byBwdWJsaXNo"));
use Claromentis\Core\Audit\Audit;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Pages\Exception\AccessDeniedException;
use Claromentis\Pages\Exception\InvalidObjectStateException;
use Claromentis\Pages\Exception\WorkingCopyExistsException;
use Claromentis\Pages\Facade\Drafts;
use Claromentis\Pages\Lock\LockService;
use Claromentis\Pages\Model\Page;
use Claromentis\Pages\Model\PageUrl;
use Claromentis\Pages\PagesAcl;
use Claromentis\Pages\Search\Indexing\PageIndexing;
use Claromentis\Search\Indexing\IndexingQueue;




class CheckoutPublish
{
    protected $drafts;
    protected $acl;
    protected $locks;
    protected Audit $audit;
    public function __construct(Drafts $_ca650641449d5d94bb77fc46da77ed8a, PagesAcl $acl, LockService $_9cd4b2152729fd679e63852ebc623594, Audit $audit)
    {
        $this->drafts = $_ca650641449d5d94bb77fc46da77ed8a;
        $this->acl = $acl;
        $this->locks = $_9cd4b2152729fd679e63852ebc623594;
        $this->audit = $audit;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Publish(SecurityContext $security, PageUrl $page_url)
    {
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if (!$this->acl->CanEditPage($security, $_8c02736ffb2efc1d69d2c9a2a34e7294)) {
            throw new AccessDeniedException();
        }
        
        
        $this->locks->Lock($page_url->id, $security->GetUserId());
        if (!$_8c02736ffb2efc1d69d2c9a2a34e7294) {
            throw new InvalidObjectStateException($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8142def44b24" . "2bc756c812f4a" . "b96a3ea"]);
        }
        $this->drafts->Publish($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294, $security);
        $this->locks->Release($page_url->id, $security->GetUserId());
        $this->audit->Success($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_3f05c7e033d5fa5883b27" . "e9248e3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_d1de6d14d3d2" . "3752c1f51753f" . "403b72e"], $page_url->id, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_e167da360aa15da9eefff0" . "30749f85ef"]);
        IndexingQueue::Reindex(PageIndexing::TYPE_NAME, $page_url->id);
    }
    
    
    
    
    
    
    
    
    
    
    public function GetWorkingCopy(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        return $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function Checkout(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $this->locks->Lock($page_url->id, $security->GetUserId());
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            throw new WorkingCopyExistsException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->CreateWorkingCopy($page_url, $security->GetUserId());
        $this->drafts->DeleteWorkingCopiesExcept($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        $this->audit->Success($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_3f05c7e033d5fa" . "5883b27e9248e3a" . "b53"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_f6ab5a050196eebba1afb1" . "07ad0143d0"], $page_url->id, $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_017e002" . "3480ae2b" . "406f84af" . "6c66f511" . "0"]);
        return $_8c02736ffb2efc1d69d2c9a2a34e7294;
    }
    
    
    
    
    
    
    
    
    public function CancelEditing(SecurityContext $security, PageUrl $page_url)
    {
        if (!$this->acl->CanEditDraft($security, $page_url)) {
            throw new AccessDeniedException();
        }
        $_8c02736ffb2efc1d69d2c9a2a34e7294 = $this->drafts->GetWorkingCopy($page_url, $security->GetUserId());
        if ($_8c02736ffb2efc1d69d2c9a2a34e7294 !== null) {
            $this->drafts->DeleteWorkingCopy($page_url, $_8c02736ffb2efc1d69d2c9a2a34e7294);
        }
        $this->audit->Failure($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_3f05c7e033d5fa5883b27e9248" . "e3ab53"], $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_f6ab5a05019" . "6eebba1afb10" . "7ad0143d0"], $page_url->id, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_f7e58afec3ec8739" . "e03ac554a75d1ffa"]);
        $this->locks->Release($page_url->id, $security->GetUserId());
    }
}